package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyMaterial invokes the cloudauth.VerifyMaterial API synchronously
func (client *Client) VerifyMaterial(request *VerifyMaterialRequest) (response *VerifyMaterialResponse, err error) {
	response = CreateVerifyMaterialResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyMaterialWithChan invokes the cloudauth.VerifyMaterial API asynchronously
func (client *Client) VerifyMaterialWithChan(request *VerifyMaterialRequest) (<-chan *VerifyMaterialResponse, <-chan error) {
	responseChan := make(chan *VerifyMaterialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyMaterial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyMaterialWithCallback invokes the cloudauth.VerifyMaterial API asynchronously
func (client *Client) VerifyMaterialWithCallback(request *VerifyMaterialRequest, callback func(response *VerifyMaterialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyMaterialResponse
		var err error
		defer close(result)
		response, err = client.VerifyMaterial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyMaterialRequest is the request struct for api VerifyMaterial
type VerifyMaterialRequest struct {
	*requests.RpcRequest
	FaceImageUrl        string `position:"Query" name:"FaceImageUrl"`
	UserId              string `position:"Query" name:"UserId"`
	IdCardBackImageUrl  string `position:"Query" name:"IdCardBackImageUrl"`
	IdCardNumber        string `position:"Query" name:"IdCardNumber"`
	IdCardFrontImageUrl string `position:"Query" name:"IdCardFrontImageUrl"`
	BizType             string `position:"Query" name:"BizType"`
	BizId               string `position:"Query" name:"BizId"`
	Name                string `position:"Query" name:"Name"`
}

// VerifyMaterialResponse is the response struct for api VerifyMaterial
type VerifyMaterialResponse struct {
	*responses.BaseResponse
	RequestId                 string                   `json:"RequestId" xml:"RequestId"`
	VerifyToken               string                   `json:"VerifyToken" xml:"VerifyToken"`
	VerifyStatus              int                      `json:"VerifyStatus" xml:"VerifyStatus"`
	AuthorityComparisionScore float64                  `json:"AuthorityComparisionScore" xml:"AuthorityComparisionScore"`
	IdCardFaceComparisonScore float64                  `json:"IdCardFaceComparisonScore" xml:"IdCardFaceComparisonScore"`
	Material                  MaterialInVerifyMaterial `json:"Material" xml:"Material"`
}

// CreateVerifyMaterialRequest creates a request to invoke VerifyMaterial API
func CreateVerifyMaterialRequest() (request *VerifyMaterialRequest) {
	request = &VerifyMaterialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "VerifyMaterial", "", "")
	request.Method = requests.POST
	return
}

// CreateVerifyMaterialResponse creates a response to parse from VerifyMaterial response
func CreateVerifyMaterialResponse() (response *VerifyMaterialResponse) {
	response = &VerifyMaterialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
