package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SavePayrollSetting invokes the companyreg.SavePayrollSetting API synchronously
func (client *Client) SavePayrollSetting(request *SavePayrollSettingRequest) (response *SavePayrollSettingResponse, err error) {
	response = CreateSavePayrollSettingResponse()
	err = client.DoAction(request, response)
	return
}

// SavePayrollSettingWithChan invokes the companyreg.SavePayrollSetting API asynchronously
func (client *Client) SavePayrollSettingWithChan(request *SavePayrollSettingRequest) (<-chan *SavePayrollSettingResponse, <-chan error) {
	responseChan := make(chan *SavePayrollSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SavePayrollSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SavePayrollSettingWithCallback invokes the companyreg.SavePayrollSetting API asynchronously
func (client *Client) SavePayrollSettingWithCallback(request *SavePayrollSettingRequest, callback func(response *SavePayrollSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SavePayrollSettingResponse
		var err error
		defer close(result)
		response, err = client.SavePayrollSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SavePayrollSettingRequest is the request struct for api SavePayrollSetting
type SavePayrollSettingRequest struct {
	*requests.RpcRequest
	BizId                string `position:"Query" name:"BizId"`
	PayrollAutoGrantRule string `position:"Query" name:"PayrollAutoGrantRule"`
	PayrollGrantMode     string `position:"Query" name:"PayrollGrantMode"`
}

// SavePayrollSettingResponse is the response struct for api SavePayrollSetting
type SavePayrollSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateSavePayrollSettingRequest creates a request to invoke SavePayrollSetting API
func CreateSavePayrollSettingRequest() (request *SavePayrollSettingRequest) {
	request = &SavePayrollSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "SavePayrollSetting", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSavePayrollSettingResponse creates a response to parse from SavePayrollSetting response
func CreateSavePayrollSettingResponse() (response *SavePayrollSettingResponse) {
	response = &SavePayrollSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
