package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHotBigKeys invokes the das.DescribeHotBigKeys API synchronously
func (client *Client) DescribeHotBigKeys(request *DescribeHotBigKeysRequest) (response *DescribeHotBigKeysResponse, err error) {
	response = CreateDescribeHotBigKeysResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHotBigKeysWithChan invokes the das.DescribeHotBigKeys API asynchronously
func (client *Client) DescribeHotBigKeysWithChan(request *DescribeHotBigKeysRequest) (<-chan *DescribeHotBigKeysResponse, <-chan error) {
	responseChan := make(chan *DescribeHotBigKeysResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHotBigKeys(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHotBigKeysWithCallback invokes the das.DescribeHotBigKeys API asynchronously
func (client *Client) DescribeHotBigKeysWithCallback(request *DescribeHotBigKeysRequest, callback func(response *DescribeHotBigKeysResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHotBigKeysResponse
		var err error
		defer close(result)
		response, err = client.DescribeHotBigKeys(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHotBigKeysRequest is the request struct for api DescribeHotBigKeys
type DescribeHotBigKeysRequest struct {
	*requests.RpcRequest
	ConsoleContext string `position:"Query" name:"ConsoleContext"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	NodeId         string `position:"Query" name:"NodeId"`
}

// DescribeHotBigKeysResponse is the response struct for api DescribeHotBigKeys
type DescribeHotBigKeysResponse struct {
	*responses.BaseResponse
	Message   string                   `json:"Message" xml:"Message"`
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Code      string                   `json:"Code" xml:"Code"`
	Success   string                   `json:"Success" xml:"Success"`
	Data      DataInDescribeHotBigKeys `json:"Data" xml:"Data"`
}

// CreateDescribeHotBigKeysRequest creates a request to invoke DescribeHotBigKeys API
func CreateDescribeHotBigKeysRequest() (request *DescribeHotBigKeysRequest) {
	request = &DescribeHotBigKeysRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "DescribeHotBigKeys", "das", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeHotBigKeysResponse creates a response to parse from DescribeHotBigKeys response
func CreateDescribeHotBigKeysResponse() (response *DescribeHotBigKeysResponse) {
	response = &DescribeHotBigKeysResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
