package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBaselineStatuses invokes the dataworks_public.ListBaselineStatuses API synchronously
func (client *Client) ListBaselineStatuses(request *ListBaselineStatusesRequest) (response *ListBaselineStatusesResponse, err error) {
	response = CreateListBaselineStatusesResponse()
	err = client.DoAction(request, response)
	return
}

// ListBaselineStatusesWithChan invokes the dataworks_public.ListBaselineStatuses API asynchronously
func (client *Client) ListBaselineStatusesWithChan(request *ListBaselineStatusesRequest) (<-chan *ListBaselineStatusesResponse, <-chan error) {
	responseChan := make(chan *ListBaselineStatusesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBaselineStatuses(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBaselineStatusesWithCallback invokes the dataworks_public.ListBaselineStatuses API asynchronously
func (client *Client) ListBaselineStatusesWithCallback(request *ListBaselineStatusesRequest, callback func(response *ListBaselineStatusesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBaselineStatusesResponse
		var err error
		defer close(result)
		response, err = client.ListBaselineStatuses(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBaselineStatusesRequest is the request struct for api ListBaselineStatuses
type ListBaselineStatusesRequest struct {
	*requests.RpcRequest
	SearchText    string           `position:"Body" name:"SearchText"`
	Owner         string           `position:"Body" name:"Owner"`
	Priority      string           `position:"Body" name:"Priority"`
	PageNumber    requests.Integer `position:"Body" name:"PageNumber"`
	TopicId       requests.Integer `position:"Body" name:"TopicId"`
	Bizdate       string           `position:"Body" name:"Bizdate"`
	FinishStatus  string           `position:"Body" name:"FinishStatus"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	BaselineTypes string           `position:"Body" name:"BaselineTypes"`
	Status        string           `position:"Body" name:"Status"`
}

// ListBaselineStatusesResponse is the response struct for api ListBaselineStatuses
type ListBaselineStatusesResponse struct {
	*responses.BaseResponse
	Success        bool                       `json:"Success" xml:"Success"`
	ErrorCode      string                     `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string                     `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int                        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string                     `json:"RequestId" xml:"RequestId"`
	Data           DataInListBaselineStatuses `json:"Data" xml:"Data"`
}

// CreateListBaselineStatusesRequest creates a request to invoke ListBaselineStatuses API
func CreateListBaselineStatusesRequest() (request *ListBaselineStatusesRequest) {
	request = &ListBaselineStatusesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListBaselineStatuses", "", "")
	request.Method = requests.POST
	return
}

// CreateListBaselineStatusesResponse creates a response to parse from ListBaselineStatuses response
func CreateListBaselineStatusesResponse() (response *ListBaselineStatusesResponse) {
	response = &ListBaselineStatusesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
