package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResumeExecutionPlanScheduler invokes the emr.ResumeExecutionPlanScheduler API synchronously
func (client *Client) ResumeExecutionPlanScheduler(request *ResumeExecutionPlanSchedulerRequest) (response *ResumeExecutionPlanSchedulerResponse, err error) {
	response = CreateResumeExecutionPlanSchedulerResponse()
	err = client.DoAction(request, response)
	return
}

// ResumeExecutionPlanSchedulerWithChan invokes the emr.ResumeExecutionPlanScheduler API asynchronously
func (client *Client) ResumeExecutionPlanSchedulerWithChan(request *ResumeExecutionPlanSchedulerRequest) (<-chan *ResumeExecutionPlanSchedulerResponse, <-chan error) {
	responseChan := make(chan *ResumeExecutionPlanSchedulerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResumeExecutionPlanScheduler(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResumeExecutionPlanSchedulerWithCallback invokes the emr.ResumeExecutionPlanScheduler API asynchronously
func (client *Client) ResumeExecutionPlanSchedulerWithCallback(request *ResumeExecutionPlanSchedulerRequest, callback func(response *ResumeExecutionPlanSchedulerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResumeExecutionPlanSchedulerResponse
		var err error
		defer close(result)
		response, err = client.ResumeExecutionPlanScheduler(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResumeExecutionPlanSchedulerRequest is the request struct for api ResumeExecutionPlanScheduler
type ResumeExecutionPlanSchedulerRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Id              string           `position:"Query" name:"Id"`
}

// ResumeExecutionPlanSchedulerResponse is the response struct for api ResumeExecutionPlanScheduler
type ResumeExecutionPlanSchedulerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateResumeExecutionPlanSchedulerRequest creates a request to invoke ResumeExecutionPlanScheduler API
func CreateResumeExecutionPlanSchedulerRequest() (request *ResumeExecutionPlanSchedulerRequest) {
	request = &ResumeExecutionPlanSchedulerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ResumeExecutionPlanScheduler", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateResumeExecutionPlanSchedulerResponse creates a response to parse from ResumeExecutionPlanScheduler response
func CreateResumeExecutionPlanSchedulerResponse() (response *ResumeExecutionPlanSchedulerResponse) {
	response = &ResumeExecutionPlanSchedulerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
