package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImageAsyncManualScanResults invokes the green.ImageAsyncManualScanResults API synchronously
func (client *Client) ImageAsyncManualScanResults(request *ImageAsyncManualScanResultsRequest) (response *ImageAsyncManualScanResultsResponse, err error) {
	response = CreateImageAsyncManualScanResultsResponse()
	err = client.DoAction(request, response)
	return
}

// ImageAsyncManualScanResultsWithChan invokes the green.ImageAsyncManualScanResults API asynchronously
func (client *Client) ImageAsyncManualScanResultsWithChan(request *ImageAsyncManualScanResultsRequest) (<-chan *ImageAsyncManualScanResultsResponse, <-chan error) {
	responseChan := make(chan *ImageAsyncManualScanResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImageAsyncManualScanResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImageAsyncManualScanResultsWithCallback invokes the green.ImageAsyncManualScanResults API asynchronously
func (client *Client) ImageAsyncManualScanResultsWithCallback(request *ImageAsyncManualScanResultsRequest, callback func(response *ImageAsyncManualScanResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImageAsyncManualScanResultsResponse
		var err error
		defer close(result)
		response, err = client.ImageAsyncManualScanResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImageAsyncManualScanResultsRequest is the request struct for api ImageAsyncManualScanResults
type ImageAsyncManualScanResultsRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// ImageAsyncManualScanResultsResponse is the response struct for api ImageAsyncManualScanResults
type ImageAsyncManualScanResultsResponse struct {
	*responses.BaseResponse
}

// CreateImageAsyncManualScanResultsRequest creates a request to invoke ImageAsyncManualScanResults API
func CreateImageAsyncManualScanResultsRequest() (request *ImageAsyncManualScanResultsRequest) {
	request = &ImageAsyncManualScanResultsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "ImageAsyncManualScanResults", "/green/image/manual/scan/results", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateImageAsyncManualScanResultsResponse creates a response to parse from ImageAsyncManualScanResults response
func CreateImageAsyncManualScanResultsResponse() (response *ImageAsyncManualScanResultsResponse) {
	response = &ImageAsyncManualScanResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
