package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateBizTypeTextLib invokes the green.UpdateBizTypeTextLib API synchronously
func (client *Client) UpdateBizTypeTextLib(request *UpdateBizTypeTextLibRequest) (response *UpdateBizTypeTextLibResponse, err error) {
	response = CreateUpdateBizTypeTextLibResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateBizTypeTextLibWithChan invokes the green.UpdateBizTypeTextLib API asynchronously
func (client *Client) UpdateBizTypeTextLibWithChan(request *UpdateBizTypeTextLibRequest) (<-chan *UpdateBizTypeTextLibResponse, <-chan error) {
	responseChan := make(chan *UpdateBizTypeTextLibResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateBizTypeTextLib(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateBizTypeTextLibWithCallback invokes the green.UpdateBizTypeTextLib API asynchronously
func (client *Client) UpdateBizTypeTextLibWithCallback(request *UpdateBizTypeTextLibRequest, callback func(response *UpdateBizTypeTextLibResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateBizTypeTextLibResponse
		var err error
		defer close(result)
		response, err = client.UpdateBizTypeTextLib(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateBizTypeTextLibRequest is the request struct for api UpdateBizTypeTextLib
type UpdateBizTypeTextLibRequest struct {
	*requests.RpcRequest
	Scene        string `position:"Query" name:"Scene"`
	SourceIp     string `position:"Query" name:"SourceIp"`
	White        string `position:"Query" name:"White"`
	Review       string `position:"Query" name:"Review"`
	Ignore       string `position:"Query" name:"Ignore"`
	BizTypeName  string `position:"Query" name:"BizTypeName"`
	Black        string `position:"Query" name:"Black"`
	ResourceType string `position:"Query" name:"ResourceType"`
}

// UpdateBizTypeTextLibResponse is the response struct for api UpdateBizTypeTextLib
type UpdateBizTypeTextLibResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateBizTypeTextLibRequest creates a request to invoke UpdateBizTypeTextLib API
func CreateUpdateBizTypeTextLibRequest() (request *UpdateBizTypeTextLibRequest) {
	request = &UpdateBizTypeTextLibRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "UpdateBizTypeTextLib", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateBizTypeTextLibResponse creates a response to parse from UpdateBizTypeTextLib response
func CreateUpdateBizTypeTextLibResponse() (response *UpdateBizTypeTextLibResponse) {
	response = &UpdateBizTypeTextLibResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
