package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCoverPipeline invokes the mts.ListCoverPipeline API synchronously
func (client *Client) ListCoverPipeline(request *ListCoverPipelineRequest) (response *ListCoverPipelineResponse, err error) {
	response = CreateListCoverPipelineResponse()
	err = client.DoAction(request, response)
	return
}

// ListCoverPipelineWithChan invokes the mts.ListCoverPipeline API asynchronously
func (client *Client) ListCoverPipelineWithChan(request *ListCoverPipelineRequest) (<-chan *ListCoverPipelineResponse, <-chan error) {
	responseChan := make(chan *ListCoverPipelineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCoverPipeline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCoverPipelineWithCallback invokes the mts.ListCoverPipeline API asynchronously
func (client *Client) ListCoverPipelineWithCallback(request *ListCoverPipelineRequest, callback func(response *ListCoverPipelineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCoverPipelineResponse
		var err error
		defer close(result)
		response, err = client.ListCoverPipeline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCoverPipelineRequest is the request struct for api ListCoverPipeline
type ListCoverPipelineRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	State                string           `position:"Query" name:"State"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ListCoverPipelineResponse is the response struct for api ListCoverPipeline
type ListCoverPipelineResponse struct {
	*responses.BaseResponse
	TotalCount   int64                           `json:"TotalCount" xml:"TotalCount"`
	PageSize     int64                           `json:"PageSize" xml:"PageSize"`
	RequestId    string                          `json:"RequestId" xml:"RequestId"`
	PageNumber   int64                           `json:"PageNumber" xml:"PageNumber"`
	PipelineList PipelineListInListCoverPipeline `json:"PipelineList" xml:"PipelineList"`
}

// CreateListCoverPipelineRequest creates a request to invoke ListCoverPipeline API
func CreateListCoverPipelineRequest() (request *ListCoverPipelineRequest) {
	request = &ListCoverPipelineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "ListCoverPipeline", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListCoverPipelineResponse creates a response to parse from ListCoverPipeline response
func CreateListCoverPipelineResponse() (response *ListCoverPipelineResponse) {
	response = &ListCoverPipelineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
