package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMPULayoutInfo invokes the rtc.DescribeMPULayoutInfo API synchronously
func (client *Client) DescribeMPULayoutInfo(request *DescribeMPULayoutInfoRequest) (response *DescribeMPULayoutInfoResponse, err error) {
	response = CreateDescribeMPULayoutInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMPULayoutInfoWithChan invokes the rtc.DescribeMPULayoutInfo API asynchronously
func (client *Client) DescribeMPULayoutInfoWithChan(request *DescribeMPULayoutInfoRequest) (<-chan *DescribeMPULayoutInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeMPULayoutInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMPULayoutInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMPULayoutInfoWithCallback invokes the rtc.DescribeMPULayoutInfo API asynchronously
func (client *Client) DescribeMPULayoutInfoWithCallback(request *DescribeMPULayoutInfoRequest, callback func(response *DescribeMPULayoutInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMPULayoutInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeMPULayoutInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMPULayoutInfoRequest is the request struct for api DescribeMPULayoutInfo
type DescribeMPULayoutInfoRequest struct {
	*requests.RpcRequest
	LayoutId requests.Integer `position:"Query" name:"LayoutId"`
	ShowLog  string           `position:"Query" name:"ShowLog"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	AppId    string           `position:"Query" name:"AppId"`
}

// DescribeMPULayoutInfoResponse is the response struct for api DescribeMPULayoutInfo
type DescribeMPULayoutInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Layout    Layout `json:"Layout" xml:"Layout"`
}

// CreateDescribeMPULayoutInfoRequest creates a request to invoke DescribeMPULayoutInfo API
func CreateDescribeMPULayoutInfoRequest() (request *DescribeMPULayoutInfoRequest) {
	request = &DescribeMPULayoutInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeMPULayoutInfo", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMPULayoutInfoResponse creates a response to parse from DescribeMPULayoutInfo response
func CreateDescribeMPULayoutInfoResponse() (response *DescribeMPULayoutInfoResponse) {
	response = &DescribeMPULayoutInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
