package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRtcChannels invokes the rtc.DescribeRtcChannels API synchronously
func (client *Client) DescribeRtcChannels(request *DescribeRtcChannelsRequest) (response *DescribeRtcChannelsResponse, err error) {
	response = CreateDescribeRtcChannelsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRtcChannelsWithChan invokes the rtc.DescribeRtcChannels API asynchronously
func (client *Client) DescribeRtcChannelsWithChan(request *DescribeRtcChannelsRequest) (<-chan *DescribeRtcChannelsResponse, <-chan error) {
	responseChan := make(chan *DescribeRtcChannelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRtcChannels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRtcChannelsWithCallback invokes the rtc.DescribeRtcChannels API asynchronously
func (client *Client) DescribeRtcChannelsWithCallback(request *DescribeRtcChannelsRequest, callback func(response *DescribeRtcChannelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRtcChannelsResponse
		var err error
		defer close(result)
		response, err = client.DescribeRtcChannels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRtcChannelsRequest is the request struct for api DescribeRtcChannels
type DescribeRtcChannelsRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	PageNo    requests.Integer `position:"Query" name:"PageNo"`
	AppId     string           `position:"Query" name:"AppId"`
	ChannelId string           `position:"Query" name:"ChannelId"`
}

// DescribeRtcChannelsResponse is the response struct for api DescribeRtcChannels
type DescribeRtcChannelsResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	PageSize  int64     `json:"PageSize" xml:"PageSize"`
	PageNo    int64     `json:"PageNo" xml:"PageNo"`
	TotalCnt  int64     `json:"TotalCnt" xml:"TotalCnt"`
	Channels  []Channel `json:"Channels" xml:"Channels"`
}

// CreateDescribeRtcChannelsRequest creates a request to invoke DescribeRtcChannels API
func CreateDescribeRtcChannelsRequest() (request *DescribeRtcChannelsRequest) {
	request = &DescribeRtcChannelsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeRtcChannels", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRtcChannelsResponse creates a response to parse from DescribeRtcChannels response
func CreateDescribeRtcChannelsResponse() (response *DescribeRtcChannelsResponse) {
	response = &DescribeRtcChannelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
