package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNamespace invokes the sae.DeleteNamespace API synchronously
func (client *Client) DeleteNamespace(request *DeleteNamespaceRequest) (response *DeleteNamespaceResponse, err error) {
	response = CreateDeleteNamespaceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNamespaceWithChan invokes the sae.DeleteNamespace API asynchronously
func (client *Client) DeleteNamespaceWithChan(request *DeleteNamespaceRequest) (<-chan *DeleteNamespaceResponse, <-chan error) {
	responseChan := make(chan *DeleteNamespaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNamespace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNamespaceWithCallback invokes the sae.DeleteNamespace API asynchronously
func (client *Client) DeleteNamespaceWithCallback(request *DeleteNamespaceRequest, callback func(response *DeleteNamespaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNamespaceResponse
		var err error
		defer close(result)
		response, err = client.DeleteNamespace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNamespaceRequest is the request struct for api DeleteNamespace
type DeleteNamespaceRequest struct {
	*requests.RoaRequest
	NamespaceId string `position:"Query" name:"NamespaceId"`
}

// DeleteNamespaceResponse is the response struct for api DeleteNamespace
type DeleteNamespaceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
}

// CreateDeleteNamespaceRequest creates a request to invoke DeleteNamespace API
func CreateDeleteNamespaceRequest() (request *DeleteNamespaceRequest) {
	request = &DeleteNamespaceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "DeleteNamespace", "/pop/v1/paas/namespace", "serverless", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteNamespaceResponse creates a response to parse from DeleteNamespace response
func CreateDeleteNamespaceResponse() (response *DeleteNamespaceResponse) {
	response = &DeleteNamespaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
