package videoenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFaceVideoTemplate invokes the videoenhan.DeleteFaceVideoTemplate API synchronously
func (client *Client) DeleteFaceVideoTemplate(request *DeleteFaceVideoTemplateRequest) (response *DeleteFaceVideoTemplateResponse, err error) {
	response = CreateDeleteFaceVideoTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFaceVideoTemplateWithChan invokes the videoenhan.DeleteFaceVideoTemplate API asynchronously
func (client *Client) DeleteFaceVideoTemplateWithChan(request *DeleteFaceVideoTemplateRequest) (<-chan *DeleteFaceVideoTemplateResponse, <-chan error) {
	responseChan := make(chan *DeleteFaceVideoTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFaceVideoTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFaceVideoTemplateWithCallback invokes the videoenhan.DeleteFaceVideoTemplate API asynchronously
func (client *Client) DeleteFaceVideoTemplateWithCallback(request *DeleteFaceVideoTemplateRequest, callback func(response *DeleteFaceVideoTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFaceVideoTemplateResponse
		var err error
		defer close(result)
		response, err = client.DeleteFaceVideoTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFaceVideoTemplateRequest is the request struct for api DeleteFaceVideoTemplate
type DeleteFaceVideoTemplateRequest struct {
	*requests.RpcRequest
	UserId     string `position:"Body" name:"UserId"`
	TemplateId string `position:"Body" name:"TemplateId"`
}

// DeleteFaceVideoTemplateResponse is the response struct for api DeleteFaceVideoTemplate
type DeleteFaceVideoTemplateResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
}

// CreateDeleteFaceVideoTemplateRequest creates a request to invoke DeleteFaceVideoTemplate API
func CreateDeleteFaceVideoTemplateRequest() (request *DeleteFaceVideoTemplateRequest) {
	request = &DeleteFaceVideoTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videoenhan", "2020-03-20", "DeleteFaceVideoTemplate", "videoenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteFaceVideoTemplateResponse creates a response to parse from DeleteFaceVideoTemplate response
func CreateDeleteFaceVideoTemplateResponse() (response *DeleteFaceVideoTemplateResponse) {
	response = &DeleteFaceVideoTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
