package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchBindTemplates invokes the vs.BatchBindTemplates API synchronously
func (client *Client) BatchBindTemplates(request *BatchBindTemplatesRequest) (response *BatchBindTemplatesResponse, err error) {
	response = CreateBatchBindTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// BatchBindTemplatesWithChan invokes the vs.BatchBindTemplates API asynchronously
func (client *Client) BatchBindTemplatesWithChan(request *BatchBindTemplatesRequest) (<-chan *BatchBindTemplatesResponse, <-chan error) {
	responseChan := make(chan *BatchBindTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchBindTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchBindTemplatesWithCallback invokes the vs.BatchBindTemplates API asynchronously
func (client *Client) BatchBindTemplatesWithCallback(request *BatchBindTemplatesRequest, callback func(response *BatchBindTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchBindTemplatesResponse
		var err error
		defer close(result)
		response, err = client.BatchBindTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchBindTemplatesRequest is the request struct for api BatchBindTemplates
type BatchBindTemplatesRequest struct {
	*requests.RpcRequest
	Replace      requests.Boolean `position:"Query" name:"Replace"`
	TemplateType string           `position:"Query" name:"TemplateType"`
	InstanceType string           `position:"Query" name:"InstanceType"`
	ShowLog      string           `position:"Query" name:"ShowLog"`
	ApplyAll     requests.Boolean `position:"Query" name:"ApplyAll"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	TemplateId   string           `position:"Query" name:"TemplateId"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
}

// BatchBindTemplatesResponse is the response struct for api BatchBindTemplates
type BatchBindTemplatesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Results   []Result `json:"Results" xml:"Results"`
}

// CreateBatchBindTemplatesRequest creates a request to invoke BatchBindTemplates API
func CreateBatchBindTemplatesRequest() (request *BatchBindTemplatesRequest) {
	request = &BatchBindTemplatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "BatchBindTemplates", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchBindTemplatesResponse creates a response to parse from BatchBindTemplates response
func CreateBatchBindTemplatesResponse() (response *BatchBindTemplatesResponse) {
	response = &BatchBindTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
