package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateParentPlatform invokes the vs.CreateParentPlatform API synchronously
func (client *Client) CreateParentPlatform(request *CreateParentPlatformRequest) (response *CreateParentPlatformResponse, err error) {
	response = CreateCreateParentPlatformResponse()
	err = client.DoAction(request, response)
	return
}

// CreateParentPlatformWithChan invokes the vs.CreateParentPlatform API asynchronously
func (client *Client) CreateParentPlatformWithChan(request *CreateParentPlatformRequest) (<-chan *CreateParentPlatformResponse, <-chan error) {
	responseChan := make(chan *CreateParentPlatformResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateParentPlatform(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateParentPlatformWithCallback invokes the vs.CreateParentPlatform API asynchronously
func (client *Client) CreateParentPlatformWithCallback(request *CreateParentPlatformRequest, callback func(response *CreateParentPlatformResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateParentPlatformResponse
		var err error
		defer close(result)
		response, err = client.CreateParentPlatform(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateParentPlatformRequest is the request struct for api CreateParentPlatform
type CreateParentPlatformRequest struct {
	*requests.RpcRequest
	GbId           string           `position:"Query" name:"GbId"`
	ClientAuth     requests.Boolean `position:"Query" name:"ClientAuth"`
	Description    string           `position:"Query" name:"Description"`
	AutoStart      requests.Boolean `position:"Query" name:"AutoStart"`
	Protocol       string           `position:"Query" name:"Protocol"`
	ClientPassword string           `position:"Query" name:"ClientPassword"`
	ShowLog        string           `position:"Query" name:"ShowLog"`
	Ip             string           `position:"Query" name:"Ip"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	Port           requests.Integer `position:"Query" name:"Port"`
	Name           string           `position:"Query" name:"Name"`
	ClientUsername string           `position:"Query" name:"ClientUsername"`
}

// CreateParentPlatformResponse is the response struct for api CreateParentPlatform
type CreateParentPlatformResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateCreateParentPlatformRequest creates a request to invoke CreateParentPlatform API
func CreateCreateParentPlatformRequest() (request *CreateParentPlatformRequest) {
	request = &CreateParentPlatformRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "CreateParentPlatform", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateParentPlatformResponse creates a response to parse from CreateParentPlatform response
func CreateCreateParentPlatformResponse() (response *CreateParentPlatformResponse) {
	response = &CreateParentPlatformResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
