package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySkillLevelsOfUser invokes the ccc.ModifySkillLevelsOfUser API synchronously
func (client *Client) ModifySkillLevelsOfUser(request *ModifySkillLevelsOfUserRequest) (response *ModifySkillLevelsOfUserResponse, err error) {
	response = CreateModifySkillLevelsOfUserResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySkillLevelsOfUserWithChan invokes the ccc.ModifySkillLevelsOfUser API asynchronously
func (client *Client) ModifySkillLevelsOfUserWithChan(request *ModifySkillLevelsOfUserRequest) (<-chan *ModifySkillLevelsOfUserResponse, <-chan error) {
	responseChan := make(chan *ModifySkillLevelsOfUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySkillLevelsOfUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySkillLevelsOfUserWithCallback invokes the ccc.ModifySkillLevelsOfUser API asynchronously
func (client *Client) ModifySkillLevelsOfUserWithCallback(request *ModifySkillLevelsOfUserRequest, callback func(response *ModifySkillLevelsOfUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySkillLevelsOfUserResponse
		var err error
		defer close(result)
		response, err = client.ModifySkillLevelsOfUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySkillLevelsOfUserRequest is the request struct for api ModifySkillLevelsOfUser
type ModifySkillLevelsOfUserRequest struct {
	*requests.RpcRequest
	UserId         string `position:"Query" name:"UserId"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	SkillLevelList string `position:"Query" name:"SkillLevelList"`
}

// ModifySkillLevelsOfUserResponse is the response struct for api ModifySkillLevelsOfUser
type ModifySkillLevelsOfUserResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
}

// CreateModifySkillLevelsOfUserRequest creates a request to invoke ModifySkillLevelsOfUser API
func CreateModifySkillLevelsOfUserRequest() (request *ModifySkillLevelsOfUserRequest) {
	request = &ModifySkillLevelsOfUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ModifySkillLevelsOfUser", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifySkillLevelsOfUserResponse creates a response to parse from ModifySkillLevelsOfUser response
func CreateModifySkillLevelsOfUserResponse() (response *ModifySkillLevelsOfUserResponse) {
	response = &ModifySkillLevelsOfUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
