package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportDISyncTasks invokes the dataworks_public.ExportDISyncTasks API synchronously
func (client *Client) ExportDISyncTasks(request *ExportDISyncTasksRequest) (response *ExportDISyncTasksResponse, err error) {
	response = CreateExportDISyncTasksResponse()
	err = client.DoAction(request, response)
	return
}

// ExportDISyncTasksWithChan invokes the dataworks_public.ExportDISyncTasks API asynchronously
func (client *Client) ExportDISyncTasksWithChan(request *ExportDISyncTasksRequest) (<-chan *ExportDISyncTasksResponse, <-chan error) {
	responseChan := make(chan *ExportDISyncTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportDISyncTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportDISyncTasksWithCallback invokes the dataworks_public.ExportDISyncTasks API asynchronously
func (client *Client) ExportDISyncTasksWithCallback(request *ExportDISyncTasksRequest, callback func(response *ExportDISyncTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportDISyncTasksResponse
		var err error
		defer close(result)
		response, err = client.ExportDISyncTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportDISyncTasksRequest is the request struct for api ExportDISyncTasks
type ExportDISyncTasksRequest struct {
	*requests.RpcRequest
	TaskType  string           `position:"Query" name:"TaskType"`
	TaskParam string           `position:"Query" name:"TaskParam"`
	ProjectId requests.Integer `position:"Query" name:"ProjectId"`
}

// ExportDISyncTasksResponse is the response struct for api ExportDISyncTasks
type ExportDISyncTasksResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Success    bool       `json:"Success" xml:"Success"`
	TaskDetail TaskDetail `json:"TaskDetail" xml:"TaskDetail"`
}

// CreateExportDISyncTasksRequest creates a request to invoke ExportDISyncTasks API
func CreateExportDISyncTasksRequest() (request *ExportDISyncTasksRequest) {
	request = &ExportDISyncTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ExportDISyncTasks", "", "")
	request.Method = requests.POST
	return
}

// CreateExportDISyncTasksResponse creates a response to parse from ExportDISyncTasks response
func CreateExportDISyncTasksResponse() (response *ExportDISyncTasksResponse) {
	response = &ExportDISyncTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
