package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDevopsProjectTaskInfo invokes the devops_rdc.GetDevopsProjectTaskInfo API synchronously
func (client *Client) GetDevopsProjectTaskInfo(request *GetDevopsProjectTaskInfoRequest) (response *GetDevopsProjectTaskInfoResponse, err error) {
	response = CreateGetDevopsProjectTaskInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetDevopsProjectTaskInfoWithChan invokes the devops_rdc.GetDevopsProjectTaskInfo API asynchronously
func (client *Client) GetDevopsProjectTaskInfoWithChan(request *GetDevopsProjectTaskInfoRequest) (<-chan *GetDevopsProjectTaskInfoResponse, <-chan error) {
	responseChan := make(chan *GetDevopsProjectTaskInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDevopsProjectTaskInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDevopsProjectTaskInfoWithCallback invokes the devops_rdc.GetDevopsProjectTaskInfo API asynchronously
func (client *Client) GetDevopsProjectTaskInfoWithCallback(request *GetDevopsProjectTaskInfoRequest, callback func(response *GetDevopsProjectTaskInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDevopsProjectTaskInfoResponse
		var err error
		defer close(result)
		response, err = client.GetDevopsProjectTaskInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDevopsProjectTaskInfoRequest is the request struct for api GetDevopsProjectTaskInfo
type GetDevopsProjectTaskInfoRequest struct {
	*requests.RpcRequest
	OrgId  string `position:"Body" name:"OrgId"`
	TaskId string `position:"Body" name:"TaskId"`
}

// GetDevopsProjectTaskInfoResponse is the response struct for api GetDevopsProjectTaskInfo
type GetDevopsProjectTaskInfoResponse struct {
	*responses.BaseResponse
	Successful bool                             `json:"Successful" xml:"Successful"`
	ErrorCode  string                           `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string                           `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string                           `json:"RequestId" xml:"RequestId"`
	Object     ObjectInGetDevopsProjectTaskInfo `json:"Object" xml:"Object"`
}

// CreateGetDevopsProjectTaskInfoRequest creates a request to invoke GetDevopsProjectTaskInfo API
func CreateGetDevopsProjectTaskInfoRequest() (request *GetDevopsProjectTaskInfoRequest) {
	request = &GetDevopsProjectTaskInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "GetDevopsProjectTaskInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDevopsProjectTaskInfoResponse creates a response to parse from GetDevopsProjectTaskInfo response
func CreateGetDevopsProjectTaskInfoResponse() (response *GetDevopsProjectTaskInfoResponse) {
	response = &GetDevopsProjectTaskInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
