package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImageResults invokes the green.ImageResults API synchronously
func (client *Client) ImageResults(request *ImageResultsRequest) (response *ImageResultsResponse, err error) {
	response = CreateImageResultsResponse()
	err = client.DoAction(request, response)
	return
}

// ImageResultsWithChan invokes the green.ImageResults API asynchronously
func (client *Client) ImageResultsWithChan(request *ImageResultsRequest) (<-chan *ImageResultsResponse, <-chan error) {
	responseChan := make(chan *ImageResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImageResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImageResultsWithCallback invokes the green.ImageResults API asynchronously
func (client *Client) ImageResultsWithCallback(request *ImageResultsRequest, callback func(response *ImageResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImageResultsResponse
		var err error
		defer close(result)
		response, err = client.ImageResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImageResultsRequest is the request struct for api ImageResults
type ImageResultsRequest struct {
	*requests.RoaRequest
}

// ImageResultsResponse is the response struct for api ImageResults
type ImageResultsResponse struct {
	*responses.BaseResponse
}

// CreateImageResultsRequest creates a request to invoke ImageResults API
func CreateImageResultsRequest() (request *ImageResultsRequest) {
	request = &ImageResultsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2016-12-22", "ImageResults", "/image/results", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateImageResultsResponse creates a response to parse from ImageResults response
func CreateImageResultsResponse() (response *ImageResultsResponse) {
	response = &ImageResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
