package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImportKeywords invokes the green.ImportKeywords API synchronously
func (client *Client) ImportKeywords(request *ImportKeywordsRequest) (response *ImportKeywordsResponse, err error) {
	response = CreateImportKeywordsResponse()
	err = client.DoAction(request, response)
	return
}

// ImportKeywordsWithChan invokes the green.ImportKeywords API asynchronously
func (client *Client) ImportKeywordsWithChan(request *ImportKeywordsRequest) (<-chan *ImportKeywordsResponse, <-chan error) {
	responseChan := make(chan *ImportKeywordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImportKeywords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImportKeywordsWithCallback invokes the green.ImportKeywords API asynchronously
func (client *Client) ImportKeywordsWithCallback(request *ImportKeywordsRequest, callback func(response *ImportKeywordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImportKeywordsResponse
		var err error
		defer close(result)
		response, err = client.ImportKeywords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImportKeywordsRequest is the request struct for api ImportKeywords
type ImportKeywordsRequest struct {
	*requests.RpcRequest
	KeywordLibId   requests.Integer `position:"Query" name:"KeywordLibId"`
	SourceIp       string           `position:"Query" name:"SourceIp"`
	KeywordsObject string           `position:"Query" name:"KeywordsObject"`
}

// ImportKeywordsResponse is the response struct for api ImportKeywords
type ImportKeywordsResponse struct {
	*responses.BaseResponse
	RequestId          string   `json:"RequestId" xml:"RequestId"`
	SuccessCount       int      `json:"SuccessCount" xml:"SuccessCount"`
	InvalidKeywordList []string `json:"InvalidKeywordList" xml:"InvalidKeywordList"`
	ValidKeywordList   []string `json:"validKeywordList" xml:"validKeywordList"`
}

// CreateImportKeywordsRequest creates a request to invoke ImportKeywords API
func CreateImportKeywordsRequest() (request *ImportKeywordsRequest) {
	request = &ImportKeywordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "ImportKeywords", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateImportKeywordsResponse creates a response to parse from ImportKeywords response
func CreateImportKeywordsResponse() (response *ImportKeywordsResponse) {
	response = &ImportKeywordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
