package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAuditRange invokes the green.UpdateAuditRange API synchronously
func (client *Client) UpdateAuditRange(request *UpdateAuditRangeRequest) (response *UpdateAuditRangeResponse, err error) {
	response = CreateUpdateAuditRangeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAuditRangeWithChan invokes the green.UpdateAuditRange API asynchronously
func (client *Client) UpdateAuditRangeWithChan(request *UpdateAuditRangeRequest) (<-chan *UpdateAuditRangeResponse, <-chan error) {
	responseChan := make(chan *UpdateAuditRangeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAuditRange(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAuditRangeWithCallback invokes the green.UpdateAuditRange API asynchronously
func (client *Client) UpdateAuditRangeWithCallback(request *UpdateAuditRangeRequest, callback func(response *UpdateAuditRangeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAuditRangeResponse
		var err error
		defer close(result)
		response, err = client.UpdateAuditRange(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAuditRangeRequest is the request struct for api UpdateAuditRange
type UpdateAuditRangeRequest struct {
	*requests.RpcRequest
	AuditRange string `position:"Query" name:"AuditRange"`
	SourceIp   string `position:"Query" name:"SourceIp"`
}

// UpdateAuditRangeResponse is the response struct for api UpdateAuditRange
type UpdateAuditRangeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAuditRangeRequest creates a request to invoke UpdateAuditRange API
func CreateUpdateAuditRangeRequest() (request *UpdateAuditRangeRequest) {
	request = &UpdateAuditRangeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "UpdateAuditRange", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAuditRangeResponse creates a response to parse from UpdateAuditRange response
func CreateUpdateAuditRangeResponse() (response *UpdateAuditRangeResponse) {
	response = &UpdateAuditRangeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
