package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateBizType invokes the green.UpdateBizType API synchronously
func (client *Client) UpdateBizType(request *UpdateBizTypeRequest) (response *UpdateBizTypeResponse, err error) {
	response = CreateUpdateBizTypeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateBizTypeWithChan invokes the green.UpdateBizType API asynchronously
func (client *Client) UpdateBizTypeWithChan(request *UpdateBizTypeRequest) (<-chan *UpdateBizTypeResponse, <-chan error) {
	responseChan := make(chan *UpdateBizTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateBizType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateBizTypeWithCallback invokes the green.UpdateBizType API asynchronously
func (client *Client) UpdateBizTypeWithCallback(request *UpdateBizTypeRequest, callback func(response *UpdateBizTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateBizTypeResponse
		var err error
		defer close(result)
		response, err = client.UpdateBizType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateBizTypeRequest is the request struct for api UpdateBizType
type UpdateBizTypeRequest struct {
	*requests.RpcRequest
	Description string `position:"Query" name:"Description"`
	SourceIp    string `position:"Query" name:"SourceIp"`
	BizTypeName string `position:"Query" name:"BizTypeName"`
}

// UpdateBizTypeResponse is the response struct for api UpdateBizType
type UpdateBizTypeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateBizTypeRequest creates a request to invoke UpdateBizType API
func CreateUpdateBizTypeRequest() (request *UpdateBizTypeRequest) {
	request = &UpdateBizTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "UpdateBizType", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateBizTypeResponse creates a response to parse from UpdateBizType response
func CreateUpdateBizTypeResponse() (response *UpdateBizTypeResponse) {
	response = &UpdateBizTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
