package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadCredentials invokes the green.UploadCredentials API synchronously
func (client *Client) UploadCredentials(request *UploadCredentialsRequest) (response *UploadCredentialsResponse, err error) {
	response = CreateUploadCredentialsResponse()
	err = client.DoAction(request, response)
	return
}

// UploadCredentialsWithChan invokes the green.UploadCredentials API asynchronously
func (client *Client) UploadCredentialsWithChan(request *UploadCredentialsRequest) (<-chan *UploadCredentialsResponse, <-chan error) {
	responseChan := make(chan *UploadCredentialsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadCredentials(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadCredentialsWithCallback invokes the green.UploadCredentials API asynchronously
func (client *Client) UploadCredentialsWithCallback(request *UploadCredentialsRequest, callback func(response *UploadCredentialsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadCredentialsResponse
		var err error
		defer close(result)
		response, err = client.UploadCredentials(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadCredentialsRequest is the request struct for api UploadCredentials
type UploadCredentialsRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// UploadCredentialsResponse is the response struct for api UploadCredentials
type UploadCredentialsResponse struct {
	*responses.BaseResponse
}

// CreateUploadCredentialsRequest creates a request to invoke UploadCredentials API
func CreateUploadCredentialsRequest() (request *UploadCredentialsRequest) {
	request = &UploadCredentialsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "UploadCredentials", "/green/credentials/uploadcredentials", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUploadCredentialsResponse creates a response to parse from UploadCredentials response
func CreateUploadCredentialsResponse() (response *UploadCredentialsResponse) {
	response = &UploadCredentialsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
