package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddClusterNode invokes the retailcloud.AddClusterNode API synchronously
func (client *Client) AddClusterNode(request *AddClusterNodeRequest) (response *AddClusterNodeResponse, err error) {
	response = CreateAddClusterNodeResponse()
	err = client.DoAction(request, response)
	return
}

// AddClusterNodeWithChan invokes the retailcloud.AddClusterNode API asynchronously
func (client *Client) AddClusterNodeWithChan(request *AddClusterNodeRequest) (<-chan *AddClusterNodeResponse, <-chan error) {
	responseChan := make(chan *AddClusterNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddClusterNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddClusterNodeWithCallback invokes the retailcloud.AddClusterNode API asynchronously
func (client *Client) AddClusterNodeWithCallback(request *AddClusterNodeRequest, callback func(response *AddClusterNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddClusterNodeResponse
		var err error
		defer close(result)
		response, err = client.AddClusterNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddClusterNodeRequest is the request struct for api AddClusterNode
type AddClusterNodeRequest struct {
	*requests.RpcRequest
	EcsInstanceIdList *[]string `position:"Query" name:"EcsInstanceIdList"  type:"Repeated"`
	ClusterInstanceId string    `position:"Query" name:"ClusterInstanceId"`
}

// AddClusterNodeResponse is the response struct for api AddClusterNode
type AddClusterNodeResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateAddClusterNodeRequest creates a request to invoke AddClusterNode API
func CreateAddClusterNodeRequest() (request *AddClusterNodeRequest) {
	request = &AddClusterNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "AddClusterNode", "", "")
	request.Method = requests.POST
	return
}

// CreateAddClusterNodeResponse creates a response to parse from AddClusterNode response
func CreateAddClusterNodeResponse() (response *AddClusterNodeResponse) {
	response = &AddClusterNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
