package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMPULayout invokes the rtc.UpdateMPULayout API synchronously
func (client *Client) UpdateMPULayout(request *UpdateMPULayoutRequest) (response *UpdateMPULayoutResponse, err error) {
	response = CreateUpdateMPULayoutResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMPULayoutWithChan invokes the rtc.UpdateMPULayout API asynchronously
func (client *Client) UpdateMPULayoutWithChan(request *UpdateMPULayoutRequest) (<-chan *UpdateMPULayoutResponse, <-chan error) {
	responseChan := make(chan *UpdateMPULayoutResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMPULayout(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMPULayoutWithCallback invokes the rtc.UpdateMPULayout API asynchronously
func (client *Client) UpdateMPULayoutWithCallback(request *UpdateMPULayoutRequest, callback func(response *UpdateMPULayoutResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMPULayoutResponse
		var err error
		defer close(result)
		response, err = client.UpdateMPULayout(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMPULayoutRequest is the request struct for api UpdateMPULayout
type UpdateMPULayoutRequest struct {
	*requests.RpcRequest
	UserPanes       *[]UpdateMPULayoutUserPanes    `position:"Query" name:"UserPanes"  type:"Repeated"`
	BackgroundColor requests.Integer               `position:"Query" name:"BackgroundColor"`
	CropMode        requests.Integer               `position:"Query" name:"CropMode"`
	LayoutIds       *[]string                      `position:"Query" name:"LayoutIds"  type:"Repeated"`
	TaskId          string                         `position:"Query" name:"TaskId"`
	ClockWidgets    *[]UpdateMPULayoutClockWidgets `position:"Query" name:"ClockWidgets"  type:"Repeated"`
	ShowLog         string                         `position:"Query" name:"ShowLog"`
	Watermarks      *[]UpdateMPULayoutWatermarks   `position:"Query" name:"Watermarks"  type:"Repeated"`
	OwnerId         requests.Integer               `position:"Query" name:"OwnerId"`
	AppId           string                         `position:"Query" name:"AppId"`
	Backgrounds     *[]UpdateMPULayoutBackgrounds  `position:"Query" name:"Backgrounds"  type:"Repeated"`
}

// UpdateMPULayoutUserPanes is a repeated param struct in UpdateMPULayoutRequest
type UpdateMPULayoutUserPanes struct {
	PaneId     string                   `name:"PaneId"`
	UserId     string                   `name:"UserId"`
	SourceType string                   `name:"SourceType"`
	Images     *[]UpdateMPULayoutImages `name:"Images" type:"Repeated"`
	Texts      *[]UpdateMPULayoutTexts  `name:"Texts" type:"Repeated"`
}

// UpdateMPULayoutClockWidgets is a repeated param struct in UpdateMPULayoutRequest
type UpdateMPULayoutClockWidgets struct {
	X         string `name:"X"`
	Y         string `name:"Y"`
	FontType  string `name:"FontType"`
	FontSize  string `name:"FontSize"`
	FontColor string `name:"FontColor"`
	ZOrder    string `name:"ZOrder"`
}

// UpdateMPULayoutWatermarks is a repeated param struct in UpdateMPULayoutRequest
type UpdateMPULayoutWatermarks struct {
	Url     string `name:"Url"`
	Alpha   string `name:"Alpha"`
	Display string `name:"Display"`
	X       string `name:"X"`
	Y       string `name:"Y"`
	Width   string `name:"Width"`
	Height  string `name:"Height"`
	ZOrder  string `name:"ZOrder"`
}

// UpdateMPULayoutBackgrounds is a repeated param struct in UpdateMPULayoutRequest
type UpdateMPULayoutBackgrounds struct {
	Url     string `name:"Url"`
	Display string `name:"Display"`
	X       string `name:"X"`
	Y       string `name:"Y"`
	Width   string `name:"Width"`
	Height  string `name:"Height"`
	ZOrder  string `name:"ZOrder"`
}

// UpdateMPULayoutImages is a repeated param struct in UpdateMPULayoutRequest
type UpdateMPULayoutImages struct {
	Url     string `name:"Url"`
	Display string `name:"Display"`
	X       string `name:"X"`
	Y       string `name:"Y"`
	Width   string `name:"Width"`
	Height  string `name:"Height"`
	ZOrder  string `name:"ZOrder"`
}

// UpdateMPULayoutTexts is a repeated param struct in UpdateMPULayoutRequest
type UpdateMPULayoutTexts struct {
	Text      string `name:"Text"`
	X         string `name:"X"`
	Y         string `name:"Y"`
	FontType  string `name:"FontType"`
	FontSize  string `name:"FontSize"`
	FontColor string `name:"FontColor"`
	ZOrder    string `name:"ZOrder"`
}

// UpdateMPULayoutResponse is the response struct for api UpdateMPULayout
type UpdateMPULayoutResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateMPULayoutRequest creates a request to invoke UpdateMPULayout API
func CreateUpdateMPULayoutRequest() (request *UpdateMPULayoutRequest) {
	request = &UpdateMPULayoutRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "UpdateMPULayout", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateMPULayoutResponse creates a response to parse from UpdateMPULayout response
func CreateUpdateMPULayoutResponse() (response *UpdateMPULayoutResponse) {
	response = &UpdateMPULayoutResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
