package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVsDomainReqTrafficData invokes the vs.DescribeVsDomainReqTrafficData API synchronously
func (client *Client) DescribeVsDomainReqTrafficData(request *DescribeVsDomainReqTrafficDataRequest) (response *DescribeVsDomainReqTrafficDataResponse, err error) {
	response = CreateDescribeVsDomainReqTrafficDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVsDomainReqTrafficDataWithChan invokes the vs.DescribeVsDomainReqTrafficData API asynchronously
func (client *Client) DescribeVsDomainReqTrafficDataWithChan(request *DescribeVsDomainReqTrafficDataRequest) (<-chan *DescribeVsDomainReqTrafficDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVsDomainReqTrafficDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVsDomainReqTrafficData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVsDomainReqTrafficDataWithCallback invokes the vs.DescribeVsDomainReqTrafficData API asynchronously
func (client *Client) DescribeVsDomainReqTrafficDataWithCallback(request *DescribeVsDomainReqTrafficDataRequest, callback func(response *DescribeVsDomainReqTrafficDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVsDomainReqTrafficDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVsDomainReqTrafficData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVsDomainReqTrafficDataRequest is the request struct for api DescribeVsDomainReqTrafficData
type DescribeVsDomainReqTrafficDataRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	ShowLog        string           `position:"Query" name:"ShowLog"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	Interval       string           `position:"Query" name:"Interval"`
}

// DescribeVsDomainReqTrafficDataResponse is the response struct for api DescribeVsDomainReqTrafficData
type DescribeVsDomainReqTrafficDataResponse struct {
	*responses.BaseResponse
	RequestId                 string                    `json:"RequestId" xml:"RequestId"`
	DomainName                string                    `json:"DomainName" xml:"DomainName"`
	StartTime                 string                    `json:"StartTime" xml:"StartTime"`
	EndTime                   string                    `json:"EndTime" xml:"EndTime"`
	DataInterval              string                    `json:"DataInterval" xml:"DataInterval"`
	ReqTrafficDataPerInterval ReqTrafficDataPerInterval `json:"ReqTrafficDataPerInterval" xml:"ReqTrafficDataPerInterval"`
}

// CreateDescribeVsDomainReqTrafficDataRequest creates a request to invoke DescribeVsDomainReqTrafficData API
func CreateDescribeVsDomainReqTrafficDataRequest() (request *DescribeVsDomainReqTrafficDataRequest) {
	request = &DescribeVsDomainReqTrafficDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeVsDomainReqTrafficData", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVsDomainReqTrafficDataResponse creates a response to parse from DescribeVsDomainReqTrafficData response
func CreateDescribeVsDomainReqTrafficDataResponse() (response *DescribeVsDomainReqTrafficDataResponse) {
	response = &DescribeVsDomainReqTrafficDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
