package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVsDomainSnapshotData invokes the vs.DescribeVsDomainSnapshotData API synchronously
func (client *Client) DescribeVsDomainSnapshotData(request *DescribeVsDomainSnapshotDataRequest) (response *DescribeVsDomainSnapshotDataResponse, err error) {
	response = CreateDescribeVsDomainSnapshotDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVsDomainSnapshotDataWithChan invokes the vs.DescribeVsDomainSnapshotData API asynchronously
func (client *Client) DescribeVsDomainSnapshotDataWithChan(request *DescribeVsDomainSnapshotDataRequest) (<-chan *DescribeVsDomainSnapshotDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVsDomainSnapshotDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVsDomainSnapshotData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVsDomainSnapshotDataWithCallback invokes the vs.DescribeVsDomainSnapshotData API asynchronously
func (client *Client) DescribeVsDomainSnapshotDataWithCallback(request *DescribeVsDomainSnapshotDataRequest, callback func(response *DescribeVsDomainSnapshotDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVsDomainSnapshotDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVsDomainSnapshotData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVsDomainSnapshotDataRequest is the request struct for api DescribeVsDomainSnapshotData
type DescribeVsDomainSnapshotDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	ShowLog    string           `position:"Query" name:"ShowLog"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVsDomainSnapshotDataResponse is the response struct for api DescribeVsDomainSnapshotData
type DescribeVsDomainSnapshotDataResponse struct {
	*responses.BaseResponse
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	DomainName              string                  `json:"DomainName" xml:"DomainName"`
	StartTime               string                  `json:"StartTime" xml:"StartTime"`
	EndTime                 string                  `json:"EndTime" xml:"EndTime"`
	SnapshotDataPerInterval SnapshotDataPerInterval `json:"SnapshotDataPerInterval" xml:"SnapshotDataPerInterval"`
}

// CreateDescribeVsDomainSnapshotDataRequest creates a request to invoke DescribeVsDomainSnapshotData API
func CreateDescribeVsDomainSnapshotDataRequest() (request *DescribeVsDomainSnapshotDataRequest) {
	request = &DescribeVsDomainSnapshotDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeVsDomainSnapshotData", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVsDomainSnapshotDataResponse creates a response to parse from DescribeVsDomainSnapshotData response
func CreateDescribeVsDomainSnapshotDataResponse() (response *DescribeVsDomainSnapshotDataResponse) {
	response = &DescribeVsDomainSnapshotDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
