package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSwimmingLane invokes the edas.ListSwimmingLane API synchronously
func (client *Client) ListSwimmingLane(request *ListSwimmingLaneRequest) (response *ListSwimmingLaneResponse, err error) {
	response = CreateListSwimmingLaneResponse()
	err = client.DoAction(request, response)
	return
}

// ListSwimmingLaneWithChan invokes the edas.ListSwimmingLane API asynchronously
func (client *Client) ListSwimmingLaneWithChan(request *ListSwimmingLaneRequest) (<-chan *ListSwimmingLaneResponse, <-chan error) {
	responseChan := make(chan *ListSwimmingLaneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSwimmingLane(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSwimmingLaneWithCallback invokes the edas.ListSwimmingLane API asynchronously
func (client *Client) ListSwimmingLaneWithCallback(request *ListSwimmingLaneRequest, callback func(response *ListSwimmingLaneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSwimmingLaneResponse
		var err error
		defer close(result)
		response, err = client.ListSwimmingLane(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSwimmingLaneRequest is the request struct for api ListSwimmingLane
type ListSwimmingLaneRequest struct {
	*requests.RoaRequest
	GroupId requests.Integer `position:"Query" name:"GroupId"`
}

// ListSwimmingLaneResponse is the response struct for api ListSwimmingLane
type ListSwimmingLaneResponse struct {
	*responses.BaseResponse
	Code      int            `json:"Code" xml:"Code"`
	Message   string         `json:"Message" xml:"Message"`
	RequestId string         `json:"RequestId" xml:"RequestId"`
	Data      []SwimmingLane `json:"Data" xml:"Data"`
}

// CreateListSwimmingLaneRequest creates a request to invoke ListSwimmingLane API
func CreateListSwimmingLaneRequest() (request *ListSwimmingLaneRequest) {
	request = &ListSwimmingLaneRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListSwimmingLane", "/pop/v5/trafficmgnt/swimming_lanes", "Edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListSwimmingLaneResponse creates a response to parse from ListSwimmingLane response
func CreateListSwimmingLaneResponse() (response *ListSwimmingLaneResponse) {
	response = &ListSwimmingLaneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
