package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListScalingActivityV2 invokes the emr.ListScalingActivityV2 API synchronously
func (client *Client) ListScalingActivityV2(request *ListScalingActivityV2Request) (response *ListScalingActivityV2Response, err error) {
	response = CreateListScalingActivityV2Response()
	err = client.DoAction(request, response)
	return
}

// ListScalingActivityV2WithChan invokes the emr.ListScalingActivityV2 API asynchronously
func (client *Client) ListScalingActivityV2WithChan(request *ListScalingActivityV2Request) (<-chan *ListScalingActivityV2Response, <-chan error) {
	responseChan := make(chan *ListScalingActivityV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListScalingActivityV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListScalingActivityV2WithCallback invokes the emr.ListScalingActivityV2 API asynchronously
func (client *Client) ListScalingActivityV2WithCallback(request *ListScalingActivityV2Request, callback func(response *ListScalingActivityV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListScalingActivityV2Response
		var err error
		defer close(result)
		response, err = client.ListScalingActivityV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListScalingActivityV2Request is the request struct for api ListScalingActivityV2
type ListScalingActivityV2Request struct {
	*requests.RpcRequest
	ResourceOwnerId   requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageCount         requests.Integer `position:"Query" name:"PageCount"`
	OrderMode         string           `position:"Query" name:"OrderMode"`
	ClusterBizId      string           `position:"Query" name:"ClusterBizId"`
	PageNumber        requests.Integer `position:"Query" name:"PageNumber"`
	HostGroupName     string           `position:"Query" name:"HostGroupName"`
	ScalingGroupBizId string           `position:"Query" name:"ScalingGroupBizId"`
	ScalingRuleName   string           `position:"Query" name:"ScalingRuleName"`
	ResourceGroupId   string           `position:"Query" name:"ResourceGroupId"`
	Limit             requests.Integer `position:"Query" name:"Limit"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	CurrentSize       requests.Integer `position:"Query" name:"CurrentSize"`
	OrderField        string           `position:"Query" name:"OrderField"`
	HostGroupId       string           `position:"Query" name:"HostGroupId"`
	Status            string           `position:"Query" name:"Status"`
}

// ListScalingActivityV2Response is the response struct for api ListScalingActivityV2
type ListScalingActivityV2Response struct {
	*responses.BaseResponse
	RequestId  string                       `json:"RequestId" xml:"RequestId"`
	PageNumber int                          `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                          `json:"PageSize" xml:"PageSize"`
	TotalCount int                          `json:"TotalCount" xml:"TotalCount"`
	NextToken  string                       `json:"NextToken" xml:"NextToken"`
	Items      ItemsInListScalingActivityV2 `json:"Items" xml:"Items"`
}

// CreateListScalingActivityV2Request creates a request to invoke ListScalingActivityV2 API
func CreateListScalingActivityV2Request() (request *ListScalingActivityV2Request) {
	request = &ListScalingActivityV2Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListScalingActivityV2", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListScalingActivityV2Response creates a response to parse from ListScalingActivityV2 response
func CreateListScalingActivityV2Response() (response *ListScalingActivityV2Response) {
	response = &ListScalingActivityV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
