package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCloudInstances invokes the sddp.DescribeCloudInstances API synchronously
// api document: https://help.aliyun.com/api/sddp/describecloudinstances.html
func (client *Client) DescribeCloudInstances(request *DescribeCloudInstancesRequest) (response *DescribeCloudInstancesResponse, err error) {
	response = CreateDescribeCloudInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCloudInstancesWithChan invokes the sddp.DescribeCloudInstances API asynchronously
// api document: https://help.aliyun.com/api/sddp/describecloudinstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCloudInstancesWithChan(request *DescribeCloudInstancesRequest) (<-chan *DescribeCloudInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeCloudInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCloudInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCloudInstancesWithCallback invokes the sddp.DescribeCloudInstances API asynchronously
// api document: https://help.aliyun.com/api/sddp/describecloudinstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCloudInstancesWithCallback(request *DescribeCloudInstancesRequest, callback func(response *DescribeCloudInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCloudInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeCloudInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCloudInstancesRequest is the request struct for api DescribeCloudInstances
type DescribeCloudInstancesRequest struct {
	*requests.RpcRequest
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Lang            string           `position:"Query" name:"Lang"`
	ResourceType    requests.Integer `position:"Query" name:"ResourceType"`
	ServiceRegionId string           `position:"Query" name:"ServiceRegionId"`
}

// DescribeCloudInstancesResponse is the response struct for api DescribeCloudInstances
type DescribeCloudInstancesResponse struct {
	*responses.BaseResponse
	RequestId         string          `json:"RequestId" xml:"RequestId"`
	CloudInstanceList []CloudInstance `json:"CloudInstanceList" xml:"CloudInstanceList"`
}

// CreateDescribeCloudInstancesRequest creates a request to invoke DescribeCloudInstances API
func CreateDescribeCloudInstancesRequest() (request *DescribeCloudInstancesRequest) {
	request = &DescribeCloudInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "DescribeCloudInstances", "sddp", "openAPI")
	return
}

// CreateDescribeCloudInstancesResponse creates a response to parse from DescribeCloudInstances response
func CreateDescribeCloudInstancesResponse() (response *DescribeCloudInstancesResponse) {
	response = &DescribeCloudInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
