package graphrbac

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/graphrbac/1.6/graphrbac"

// AddOwnerParameters request parameters for adding a owner to an application.
type AddOwnerParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// URL - A owner object URL, such as "https://graph.windows.net/0b1f9851-1bf0-433f-aec3-cb9272f093dc/directoryObjects/f260bbc4-c254-447b-94cf-293b5ec434dd", where "0b1f9851-1bf0-433f-aec3-cb9272f093dc" is the tenantId and "f260bbc4-c254-447b-94cf-293b5ec434dd" is the objectId of the owner (user, application, servicePrincipal, group) to be added.
	URL *string `json:"url,omitempty"`
}

// MarshalJSON is the custom marshaler for AddOwnerParameters.
func (aop AddOwnerParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aop.URL != nil {
		objectMap["url"] = aop.URL
	}
	for k, v := range aop.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AddOwnerParameters struct.
func (aop *AddOwnerParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if aop.AdditionalProperties == nil {
					aop.AdditionalProperties = make(map[string]interface{})
				}
				aop.AdditionalProperties[k] = additionalProperties
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				aop.URL = &URL
			}
		}
	}

	return nil
}

// ADGroup active Directory group information.
type ADGroup struct {
	autorest.Response `json:"-"`
	// DisplayName - The display name of the group.
	DisplayName *string `json:"displayName,omitempty"`
	// MailEnabled - Whether the group is mail-enabled. Must be false. This is because only pure security groups can be created using the Graph API.
	MailEnabled *bool `json:"mailEnabled,omitempty"`
	// MailNickname - The mail alias for the group.
	MailNickname *string `json:"mailNickname,omitempty"`
	// SecurityEnabled - Whether the group is security-enable.
	SecurityEnabled *bool `json:"securityEnabled,omitempty"`
	// Mail - The primary email address of the group.
	Mail *string `json:"mail,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ObjectID - READ-ONLY; The object ID.
	ObjectID *string `json:"objectId,omitempty"`
	// DeletionTimestamp - READ-ONLY; The time at which the directory object was deleted.
	DeletionTimestamp *date.Time `json:"deletionTimestamp,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeDirectoryObject', 'ObjectTypeApplication', 'ObjectTypeGroup', 'ObjectTypeServicePrincipal', 'ObjectTypeUser'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for ADGroup.
func (ag ADGroup) MarshalJSON() ([]byte, error) {
	ag.ObjectType = ObjectTypeGroup
	objectMap := make(map[string]interface{})
	if ag.DisplayName != nil {
		objectMap["displayName"] = ag.DisplayName
	}
	if ag.MailEnabled != nil {
		objectMap["mailEnabled"] = ag.MailEnabled
	}
	if ag.MailNickname != nil {
		objectMap["mailNickname"] = ag.MailNickname
	}
	if ag.SecurityEnabled != nil {
		objectMap["securityEnabled"] = ag.SecurityEnabled
	}
	if ag.Mail != nil {
		objectMap["mail"] = ag.Mail
	}
	if ag.ObjectType != "" {
		objectMap["objectType"] = ag.ObjectType
	}
	for k, v := range ag.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsApplication is the BasicDirectoryObject implementation for ADGroup.
func (ag ADGroup) AsApplication() (*Application, bool) {
	return nil, false
}

// AsADGroup is the BasicDirectoryObject implementation for ADGroup.
func (ag ADGroup) AsADGroup() (*ADGroup, bool) {
	return &ag, true
}

// AsServicePrincipal is the BasicDirectoryObject implementation for ADGroup.
func (ag ADGroup) AsServicePrincipal() (*ServicePrincipal, bool) {
	return nil, false
}

// AsUser is the BasicDirectoryObject implementation for ADGroup.
func (ag ADGroup) AsUser() (*User, bool) {
	return nil, false
}

// AsDirectoryObject is the BasicDirectoryObject implementation for ADGroup.
func (ag ADGroup) AsDirectoryObject() (*DirectoryObject, bool) {
	return nil, false
}

// AsBasicDirectoryObject is the BasicDirectoryObject implementation for ADGroup.
func (ag ADGroup) AsBasicDirectoryObject() (BasicDirectoryObject, bool) {
	return &ag, true
}

// UnmarshalJSON is the custom unmarshaler for ADGroup struct.
func (ag *ADGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				ag.DisplayName = &displayName
			}
		case "mailEnabled":
			if v != nil {
				var mailEnabled bool
				err = json.Unmarshal(*v, &mailEnabled)
				if err != nil {
					return err
				}
				ag.MailEnabled = &mailEnabled
			}
		case "mailNickname":
			if v != nil {
				var mailNickname string
				err = json.Unmarshal(*v, &mailNickname)
				if err != nil {
					return err
				}
				ag.MailNickname = &mailNickname
			}
		case "securityEnabled":
			if v != nil {
				var securityEnabled bool
				err = json.Unmarshal(*v, &securityEnabled)
				if err != nil {
					return err
				}
				ag.SecurityEnabled = &securityEnabled
			}
		case "mail":
			if v != nil {
				var mailVar string
				err = json.Unmarshal(*v, &mailVar)
				if err != nil {
					return err
				}
				ag.Mail = &mailVar
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ag.AdditionalProperties == nil {
					ag.AdditionalProperties = make(map[string]interface{})
				}
				ag.AdditionalProperties[k] = additionalProperties
			}
		case "objectId":
			if v != nil {
				var objectID string
				err = json.Unmarshal(*v, &objectID)
				if err != nil {
					return err
				}
				ag.ObjectID = &objectID
			}
		case "deletionTimestamp":
			if v != nil {
				var deletionTimestamp date.Time
				err = json.Unmarshal(*v, &deletionTimestamp)
				if err != nil {
					return err
				}
				ag.DeletionTimestamp = &deletionTimestamp
			}
		case "objectType":
			if v != nil {
				var objectType ObjectType
				err = json.Unmarshal(*v, &objectType)
				if err != nil {
					return err
				}
				ag.ObjectType = objectType
			}
		}
	}

	return nil
}

// Application active Directory application information.
type Application struct {
	autorest.Response `json:"-"`
	// AppID - The application ID.
	AppID *string `json:"appId,omitempty"`
	// AllowGuestsSignIn - A property on the application to indicate if the application accepts other IDPs or not or partially accepts.
	AllowGuestsSignIn *bool `json:"allowGuestsSignIn,omitempty"`
	// AllowPassthroughUsers - Indicates that the application supports pass through users who have no presence in the resource tenant.
	AllowPassthroughUsers *bool `json:"allowPassthroughUsers,omitempty"`
	// AppLogoURL - The url for the application logo image stored in a CDN.
	AppLogoURL *string `json:"appLogoUrl,omitempty"`
	// AppRoles - The collection of application roles that an application may declare. These roles can be assigned to users, groups or service principals.
	AppRoles *[]AppRole `json:"appRoles,omitempty"`
	// AppPermissions - The application permissions.
	AppPermissions *[]string `json:"appPermissions,omitempty"`
	// AvailableToOtherTenants - Whether the application is available to other tenants.
	AvailableToOtherTenants *bool `json:"availableToOtherTenants,omitempty"`
	// DisplayName - The display name of the application.
	DisplayName *string `json:"displayName,omitempty"`
	// ErrorURL - A URL provided by the author of the application to report errors when using the application.
	ErrorURL *string `json:"errorUrl,omitempty"`
	// GroupMembershipClaims - Configures the groups claim issued in a user or OAuth 2.0 access token that the app expects. Possible values include: 'None', 'SecurityGroup', 'All'
	GroupMembershipClaims GroupMembershipClaimTypes `json:"groupMembershipClaims,omitempty"`
	// Homepage - The home page of the application.
	Homepage *string `json:"homepage,omitempty"`
	// IdentifierUris - A collection of URIs for the application.
	IdentifierUris *[]string `json:"identifierUris,omitempty"`
	// InformationalUrls - URLs with more information about the application.
	InformationalUrls *InformationalURL `json:"informationalUrls,omitempty"`
	// IsDeviceOnlyAuthSupported - Specifies whether this application supports device authentication without a user. The default is false.
	IsDeviceOnlyAuthSupported *bool `json:"isDeviceOnlyAuthSupported,omitempty"`
	// KeyCredentials - A collection of KeyCredential objects.
	KeyCredentials *[]KeyCredential `json:"keyCredentials,omitempty"`
	// KnownClientApplications - Client applications that are tied to this resource application. Consent to any of the known client applications will result in implicit consent to the resource application through a combined consent dialog (showing the OAuth permission scopes required by the client and the resource).
	KnownClientApplications *[]string `json:"knownClientApplications,omitempty"`
	// LogoutURL - the url of the logout page
	LogoutURL *string `json:"logoutUrl,omitempty"`
	// Oauth2AllowImplicitFlow - Whether to allow implicit grant flow for OAuth2
	Oauth2AllowImplicitFlow *bool `json:"oauth2AllowImplicitFlow,omitempty"`
	// Oauth2AllowURLPathMatching - Specifies whether during a token Request Azure AD will allow path matching of the redirect URI against the applications collection of replyURLs. The default is false.
	Oauth2AllowURLPathMatching *bool `json:"oauth2AllowUrlPathMatching,omitempty"`
	// Oauth2Permissions - The collection of OAuth 2.0 permission scopes that the web API (resource) application exposes to client applications. These permission scopes may be granted to client applications during consent.
	Oauth2Permissions *[]OAuth2Permission `json:"oauth2Permissions,omitempty"`
	// Oauth2RequirePostResponse - Specifies whether, as part of OAuth 2.0 token requests, Azure AD will allow POST requests, as opposed to GET requests. The default is false, which specifies that only GET requests will be allowed.
	Oauth2RequirePostResponse *bool `json:"oauth2RequirePostResponse,omitempty"`
	// OrgRestrictions - A list of tenants allowed to access application.
	OrgRestrictions *[]string       `json:"orgRestrictions,omitempty"`
	OptionalClaims  *OptionalClaims `json:"optionalClaims,omitempty"`
	// PasswordCredentials - A collection of PasswordCredential objects
	PasswordCredentials *[]PasswordCredential `json:"passwordCredentials,omitempty"`
	// PreAuthorizedApplications - list of pre-authorized applications.
	PreAuthorizedApplications *[]PreAuthorizedApplication `json:"preAuthorizedApplications,omitempty"`
	// PublicClient - Specifies whether this application is a public client (such as an installed application running on a mobile device). Default is false.
	PublicClient *bool `json:"publicClient,omitempty"`
	// PublisherDomain - Reliable domain which can be used to identify an application.
	PublisherDomain *string `json:"publisherDomain,omitempty"`
	// ReplyUrls - A collection of reply URLs for the application.
	ReplyUrls *[]string `json:"replyUrls,omitempty"`
	// RequiredResourceAccess - Specifies resources that this application requires access to and the set of OAuth permission scopes and application roles that it needs under each of those resources. This pre-configuration of required resource access drives the consent experience.
	RequiredResourceAccess *[]RequiredResourceAccess `json:"requiredResourceAccess,omitempty"`
	// SamlMetadataURL - The URL to the SAML metadata for the application.
	SamlMetadataURL *string `json:"samlMetadataUrl,omitempty"`
	// SignInAudience - Audience for signing in to the application (AzureADMyOrganization, AzureADAllOrganizations, AzureADAndMicrosoftAccounts).
	SignInAudience *string `json:"signInAudience,omitempty"`
	// WwwHomepage - The primary Web page.
	WwwHomepage *string `json:"wwwHomepage,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ObjectID - READ-ONLY; The object ID.
	ObjectID *string `json:"objectId,omitempty"`
	// DeletionTimestamp - READ-ONLY; The time at which the directory object was deleted.
	DeletionTimestamp *date.Time `json:"deletionTimestamp,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeDirectoryObject', 'ObjectTypeApplication', 'ObjectTypeGroup', 'ObjectTypeServicePrincipal', 'ObjectTypeUser'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for Application.
func (a Application) MarshalJSON() ([]byte, error) {
	a.ObjectType = ObjectTypeApplication
	objectMap := make(map[string]interface{})
	if a.AppID != nil {
		objectMap["appId"] = a.AppID
	}
	if a.AllowGuestsSignIn != nil {
		objectMap["allowGuestsSignIn"] = a.AllowGuestsSignIn
	}
	if a.AllowPassthroughUsers != nil {
		objectMap["allowPassthroughUsers"] = a.AllowPassthroughUsers
	}
	if a.AppLogoURL != nil {
		objectMap["appLogoUrl"] = a.AppLogoURL
	}
	if a.AppRoles != nil {
		objectMap["appRoles"] = a.AppRoles
	}
	if a.AppPermissions != nil {
		objectMap["appPermissions"] = a.AppPermissions
	}
	if a.AvailableToOtherTenants != nil {
		objectMap["availableToOtherTenants"] = a.AvailableToOtherTenants
	}
	if a.DisplayName != nil {
		objectMap["displayName"] = a.DisplayName
	}
	if a.ErrorURL != nil {
		objectMap["errorUrl"] = a.ErrorURL
	}
	if a.GroupMembershipClaims != "" {
		objectMap["groupMembershipClaims"] = a.GroupMembershipClaims
	}
	if a.Homepage != nil {
		objectMap["homepage"] = a.Homepage
	}
	if a.IdentifierUris != nil {
		objectMap["identifierUris"] = a.IdentifierUris
	}
	if a.InformationalUrls != nil {
		objectMap["informationalUrls"] = a.InformationalUrls
	}
	if a.IsDeviceOnlyAuthSupported != nil {
		objectMap["isDeviceOnlyAuthSupported"] = a.IsDeviceOnlyAuthSupported
	}
	if a.KeyCredentials != nil {
		objectMap["keyCredentials"] = a.KeyCredentials
	}
	if a.KnownClientApplications != nil {
		objectMap["knownClientApplications"] = a.KnownClientApplications
	}
	if a.LogoutURL != nil {
		objectMap["logoutUrl"] = a.LogoutURL
	}
	if a.Oauth2AllowImplicitFlow != nil {
		objectMap["oauth2AllowImplicitFlow"] = a.Oauth2AllowImplicitFlow
	}
	if a.Oauth2AllowURLPathMatching != nil {
		objectMap["oauth2AllowUrlPathMatching"] = a.Oauth2AllowURLPathMatching
	}
	if a.Oauth2Permissions != nil {
		objectMap["oauth2Permissions"] = a.Oauth2Permissions
	}
	if a.Oauth2RequirePostResponse != nil {
		objectMap["oauth2RequirePostResponse"] = a.Oauth2RequirePostResponse
	}
	if a.OrgRestrictions != nil {
		objectMap["orgRestrictions"] = a.OrgRestrictions
	}
	if a.OptionalClaims != nil {
		objectMap["optionalClaims"] = a.OptionalClaims
	}
	if a.PasswordCredentials != nil {
		objectMap["passwordCredentials"] = a.PasswordCredentials
	}
	if a.PreAuthorizedApplications != nil {
		objectMap["preAuthorizedApplications"] = a.PreAuthorizedApplications
	}
	if a.PublicClient != nil {
		objectMap["publicClient"] = a.PublicClient
	}
	if a.PublisherDomain != nil {
		objectMap["publisherDomain"] = a.PublisherDomain
	}
	if a.ReplyUrls != nil {
		objectMap["replyUrls"] = a.ReplyUrls
	}
	if a.RequiredResourceAccess != nil {
		objectMap["requiredResourceAccess"] = a.RequiredResourceAccess
	}
	if a.SamlMetadataURL != nil {
		objectMap["samlMetadataUrl"] = a.SamlMetadataURL
	}
	if a.SignInAudience != nil {
		objectMap["signInAudience"] = a.SignInAudience
	}
	if a.WwwHomepage != nil {
		objectMap["wwwHomepage"] = a.WwwHomepage
	}
	if a.ObjectType != "" {
		objectMap["objectType"] = a.ObjectType
	}
	for k, v := range a.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsApplication is the BasicDirectoryObject implementation for Application.
func (a Application) AsApplication() (*Application, bool) {
	return &a, true
}

// AsADGroup is the BasicDirectoryObject implementation for Application.
func (a Application) AsADGroup() (*ADGroup, bool) {
	return nil, false
}

// AsServicePrincipal is the BasicDirectoryObject implementation for Application.
func (a Application) AsServicePrincipal() (*ServicePrincipal, bool) {
	return nil, false
}

// AsUser is the BasicDirectoryObject implementation for Application.
func (a Application) AsUser() (*User, bool) {
	return nil, false
}

// AsDirectoryObject is the BasicDirectoryObject implementation for Application.
func (a Application) AsDirectoryObject() (*DirectoryObject, bool) {
	return nil, false
}

// AsBasicDirectoryObject is the BasicDirectoryObject implementation for Application.
func (a Application) AsBasicDirectoryObject() (BasicDirectoryObject, bool) {
	return &a, true
}

// UnmarshalJSON is the custom unmarshaler for Application struct.
func (a *Application) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "appId":
			if v != nil {
				var appID string
				err = json.Unmarshal(*v, &appID)
				if err != nil {
					return err
				}
				a.AppID = &appID
			}
		case "allowGuestsSignIn":
			if v != nil {
				var allowGuestsSignIn bool
				err = json.Unmarshal(*v, &allowGuestsSignIn)
				if err != nil {
					return err
				}
				a.AllowGuestsSignIn = &allowGuestsSignIn
			}
		case "allowPassthroughUsers":
			if v != nil {
				var allowPassthroughUsers bool
				err = json.Unmarshal(*v, &allowPassthroughUsers)
				if err != nil {
					return err
				}
				a.AllowPassthroughUsers = &allowPassthroughUsers
			}
		case "appLogoUrl":
			if v != nil {
				var appLogoURL string
				err = json.Unmarshal(*v, &appLogoURL)
				if err != nil {
					return err
				}
				a.AppLogoURL = &appLogoURL
			}
		case "appRoles":
			if v != nil {
				var appRoles []AppRole
				err = json.Unmarshal(*v, &appRoles)
				if err != nil {
					return err
				}
				a.AppRoles = &appRoles
			}
		case "appPermissions":
			if v != nil {
				var appPermissions []string
				err = json.Unmarshal(*v, &appPermissions)
				if err != nil {
					return err
				}
				a.AppPermissions = &appPermissions
			}
		case "availableToOtherTenants":
			if v != nil {
				var availableToOtherTenants bool
				err = json.Unmarshal(*v, &availableToOtherTenants)
				if err != nil {
					return err
				}
				a.AvailableToOtherTenants = &availableToOtherTenants
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				a.DisplayName = &displayName
			}
		case "errorUrl":
			if v != nil {
				var errorURL string
				err = json.Unmarshal(*v, &errorURL)
				if err != nil {
					return err
				}
				a.ErrorURL = &errorURL
			}
		case "groupMembershipClaims":
			if v != nil {
				var groupMembershipClaims GroupMembershipClaimTypes
				err = json.Unmarshal(*v, &groupMembershipClaims)
				if err != nil {
					return err
				}
				a.GroupMembershipClaims = groupMembershipClaims
			}
		case "homepage":
			if v != nil {
				var homepage string
				err = json.Unmarshal(*v, &homepage)
				if err != nil {
					return err
				}
				a.Homepage = &homepage
			}
		case "identifierUris":
			if v != nil {
				var identifierUris []string
				err = json.Unmarshal(*v, &identifierUris)
				if err != nil {
					return err
				}
				a.IdentifierUris = &identifierUris
			}
		case "informationalUrls":
			if v != nil {
				var informationalUrls InformationalURL
				err = json.Unmarshal(*v, &informationalUrls)
				if err != nil {
					return err
				}
				a.InformationalUrls = &informationalUrls
			}
		case "isDeviceOnlyAuthSupported":
			if v != nil {
				var isDeviceOnlyAuthSupported bool
				err = json.Unmarshal(*v, &isDeviceOnlyAuthSupported)
				if err != nil {
					return err
				}
				a.IsDeviceOnlyAuthSupported = &isDeviceOnlyAuthSupported
			}
		case "keyCredentials":
			if v != nil {
				var keyCredentials []KeyCredential
				err = json.Unmarshal(*v, &keyCredentials)
				if err != nil {
					return err
				}
				a.KeyCredentials = &keyCredentials
			}
		case "knownClientApplications":
			if v != nil {
				var knownClientApplications []string
				err = json.Unmarshal(*v, &knownClientApplications)
				if err != nil {
					return err
				}
				a.KnownClientApplications = &knownClientApplications
			}
		case "logoutUrl":
			if v != nil {
				var logoutURL string
				err = json.Unmarshal(*v, &logoutURL)
				if err != nil {
					return err
				}
				a.LogoutURL = &logoutURL
			}
		case "oauth2AllowImplicitFlow":
			if v != nil {
				var oauth2AllowImplicitFlow bool
				err = json.Unmarshal(*v, &oauth2AllowImplicitFlow)
				if err != nil {
					return err
				}
				a.Oauth2AllowImplicitFlow = &oauth2AllowImplicitFlow
			}
		case "oauth2AllowUrlPathMatching":
			if v != nil {
				var oauth2AllowURLPathMatching bool
				err = json.Unmarshal(*v, &oauth2AllowURLPathMatching)
				if err != nil {
					return err
				}
				a.Oauth2AllowURLPathMatching = &oauth2AllowURLPathMatching
			}
		case "oauth2Permissions":
			if v != nil {
				var oauth2Permissions []OAuth2Permission
				err = json.Unmarshal(*v, &oauth2Permissions)
				if err != nil {
					return err
				}
				a.Oauth2Permissions = &oauth2Permissions
			}
		case "oauth2RequirePostResponse":
			if v != nil {
				var oauth2RequirePostResponse bool
				err = json.Unmarshal(*v, &oauth2RequirePostResponse)
				if err != nil {
					return err
				}
				a.Oauth2RequirePostResponse = &oauth2RequirePostResponse
			}
		case "orgRestrictions":
			if v != nil {
				var orgRestrictions []string
				err = json.Unmarshal(*v, &orgRestrictions)
				if err != nil {
					return err
				}
				a.OrgRestrictions = &orgRestrictions
			}
		case "optionalClaims":
			if v != nil {
				var optionalClaims OptionalClaims
				err = json.Unmarshal(*v, &optionalClaims)
				if err != nil {
					return err
				}
				a.OptionalClaims = &optionalClaims
			}
		case "passwordCredentials":
			if v != nil {
				var passwordCredentials []PasswordCredential
				err = json.Unmarshal(*v, &passwordCredentials)
				if err != nil {
					return err
				}
				a.PasswordCredentials = &passwordCredentials
			}
		case "preAuthorizedApplications":
			if v != nil {
				var preAuthorizedApplications []PreAuthorizedApplication
				err = json.Unmarshal(*v, &preAuthorizedApplications)
				if err != nil {
					return err
				}
				a.PreAuthorizedApplications = &preAuthorizedApplications
			}
		case "publicClient":
			if v != nil {
				var publicClient bool
				err = json.Unmarshal(*v, &publicClient)
				if err != nil {
					return err
				}
				a.PublicClient = &publicClient
			}
		case "publisherDomain":
			if v != nil {
				var publisherDomain string
				err = json.Unmarshal(*v, &publisherDomain)
				if err != nil {
					return err
				}
				a.PublisherDomain = &publisherDomain
			}
		case "replyUrls":
			if v != nil {
				var replyUrls []string
				err = json.Unmarshal(*v, &replyUrls)
				if err != nil {
					return err
				}
				a.ReplyUrls = &replyUrls
			}
		case "requiredResourceAccess":
			if v != nil {
				var requiredResourceAccess []RequiredResourceAccess
				err = json.Unmarshal(*v, &requiredResourceAccess)
				if err != nil {
					return err
				}
				a.RequiredResourceAccess = &requiredResourceAccess
			}
		case "samlMetadataUrl":
			if v != nil {
				var samlMetadataURL string
				err = json.Unmarshal(*v, &samlMetadataURL)
				if err != nil {
					return err
				}
				a.SamlMetadataURL = &samlMetadataURL
			}
		case "signInAudience":
			if v != nil {
				var signInAudience string
				err = json.Unmarshal(*v, &signInAudience)
				if err != nil {
					return err
				}
				a.SignInAudience = &signInAudience
			}
		case "wwwHomepage":
			if v != nil {
				var wwwHomepage string
				err = json.Unmarshal(*v, &wwwHomepage)
				if err != nil {
					return err
				}
				a.WwwHomepage = &wwwHomepage
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if a.AdditionalProperties == nil {
					a.AdditionalProperties = make(map[string]interface{})
				}
				a.AdditionalProperties[k] = additionalProperties
			}
		case "objectId":
			if v != nil {
				var objectID string
				err = json.Unmarshal(*v, &objectID)
				if err != nil {
					return err
				}
				a.ObjectID = &objectID
			}
		case "deletionTimestamp":
			if v != nil {
				var deletionTimestamp date.Time
				err = json.Unmarshal(*v, &deletionTimestamp)
				if err != nil {
					return err
				}
				a.DeletionTimestamp = &deletionTimestamp
			}
		case "objectType":
			if v != nil {
				var objectType ObjectType
				err = json.Unmarshal(*v, &objectType)
				if err != nil {
					return err
				}
				a.ObjectType = objectType
			}
		}
	}

	return nil
}

// ApplicationBase active Directive Application common properties shared among GET, POST and PATCH
type ApplicationBase struct {
	// AllowGuestsSignIn - A property on the application to indicate if the application accepts other IDPs or not or partially accepts.
	AllowGuestsSignIn *bool `json:"allowGuestsSignIn,omitempty"`
	// AllowPassthroughUsers - Indicates that the application supports pass through users who have no presence in the resource tenant.
	AllowPassthroughUsers *bool `json:"allowPassthroughUsers,omitempty"`
	// AppLogoURL - The url for the application logo image stored in a CDN.
	AppLogoURL *string `json:"appLogoUrl,omitempty"`
	// AppRoles - The collection of application roles that an application may declare. These roles can be assigned to users, groups or service principals.
	AppRoles *[]AppRole `json:"appRoles,omitempty"`
	// AppPermissions - The application permissions.
	AppPermissions *[]string `json:"appPermissions,omitempty"`
	// AvailableToOtherTenants - Whether the application is available to other tenants.
	AvailableToOtherTenants *bool `json:"availableToOtherTenants,omitempty"`
	// ErrorURL - A URL provided by the author of the application to report errors when using the application.
	ErrorURL *string `json:"errorUrl,omitempty"`
	// GroupMembershipClaims - Configures the groups claim issued in a user or OAuth 2.0 access token that the app expects. Possible values include: 'None', 'SecurityGroup', 'All'
	GroupMembershipClaims GroupMembershipClaimTypes `json:"groupMembershipClaims,omitempty"`
	// Homepage - The home page of the application.
	Homepage *string `json:"homepage,omitempty"`
	// InformationalUrls - URLs with more information about the application.
	InformationalUrls *InformationalURL `json:"informationalUrls,omitempty"`
	// IsDeviceOnlyAuthSupported - Specifies whether this application supports device authentication without a user. The default is false.
	IsDeviceOnlyAuthSupported *bool `json:"isDeviceOnlyAuthSupported,omitempty"`
	// KeyCredentials - A collection of KeyCredential objects.
	KeyCredentials *[]KeyCredential `json:"keyCredentials,omitempty"`
	// KnownClientApplications - Client applications that are tied to this resource application. Consent to any of the known client applications will result in implicit consent to the resource application through a combined consent dialog (showing the OAuth permission scopes required by the client and the resource).
	KnownClientApplications *[]string `json:"knownClientApplications,omitempty"`
	// LogoutURL - the url of the logout page
	LogoutURL *string `json:"logoutUrl,omitempty"`
	// Oauth2AllowImplicitFlow - Whether to allow implicit grant flow for OAuth2
	Oauth2AllowImplicitFlow *bool `json:"oauth2AllowImplicitFlow,omitempty"`
	// Oauth2AllowURLPathMatching - Specifies whether during a token Request Azure AD will allow path matching of the redirect URI against the applications collection of replyURLs. The default is false.
	Oauth2AllowURLPathMatching *bool `json:"oauth2AllowUrlPathMatching,omitempty"`
	// Oauth2Permissions - The collection of OAuth 2.0 permission scopes that the web API (resource) application exposes to client applications. These permission scopes may be granted to client applications during consent.
	Oauth2Permissions *[]OAuth2Permission `json:"oauth2Permissions,omitempty"`
	// Oauth2RequirePostResponse - Specifies whether, as part of OAuth 2.0 token requests, Azure AD will allow POST requests, as opposed to GET requests. The default is false, which specifies that only GET requests will be allowed.
	Oauth2RequirePostResponse *bool `json:"oauth2RequirePostResponse,omitempty"`
	// OrgRestrictions - A list of tenants allowed to access application.
	OrgRestrictions *[]string       `json:"orgRestrictions,omitempty"`
	OptionalClaims  *OptionalClaims `json:"optionalClaims,omitempty"`
	// PasswordCredentials - A collection of PasswordCredential objects
	PasswordCredentials *[]PasswordCredential `json:"passwordCredentials,omitempty"`
	// PreAuthorizedApplications - list of pre-authorized applications.
	PreAuthorizedApplications *[]PreAuthorizedApplication `json:"preAuthorizedApplications,omitempty"`
	// PublicClient - Specifies whether this application is a public client (such as an installed application running on a mobile device). Default is false.
	PublicClient *bool `json:"publicClient,omitempty"`
	// PublisherDomain - Reliable domain which can be used to identify an application.
	PublisherDomain *string `json:"publisherDomain,omitempty"`
	// ReplyUrls - A collection of reply URLs for the application.
	ReplyUrls *[]string `json:"replyUrls,omitempty"`
	// RequiredResourceAccess - Specifies resources that this application requires access to and the set of OAuth permission scopes and application roles that it needs under each of those resources. This pre-configuration of required resource access drives the consent experience.
	RequiredResourceAccess *[]RequiredResourceAccess `json:"requiredResourceAccess,omitempty"`
	// SamlMetadataURL - The URL to the SAML metadata for the application.
	SamlMetadataURL *string `json:"samlMetadataUrl,omitempty"`
	// SignInAudience - Audience for signing in to the application (AzureADMyOrganization, AzureADAllOrganizations, AzureADAndMicrosoftAccounts).
	SignInAudience *string `json:"signInAudience,omitempty"`
	// WwwHomepage - The primary Web page.
	WwwHomepage *string `json:"wwwHomepage,omitempty"`
}

// ApplicationCreateParameters request parameters for creating a new application.
type ApplicationCreateParameters struct {
	// DisplayName - The display name of the application.
	DisplayName *string `json:"displayName,omitempty"`
	// IdentifierUris - A collection of URIs for the application.
	IdentifierUris *[]string `json:"identifierUris,omitempty"`
	// AllowGuestsSignIn - A property on the application to indicate if the application accepts other IDPs or not or partially accepts.
	AllowGuestsSignIn *bool `json:"allowGuestsSignIn,omitempty"`
	// AllowPassthroughUsers - Indicates that the application supports pass through users who have no presence in the resource tenant.
	AllowPassthroughUsers *bool `json:"allowPassthroughUsers,omitempty"`
	// AppLogoURL - The url for the application logo image stored in a CDN.
	AppLogoURL *string `json:"appLogoUrl,omitempty"`
	// AppRoles - The collection of application roles that an application may declare. These roles can be assigned to users, groups or service principals.
	AppRoles *[]AppRole `json:"appRoles,omitempty"`
	// AppPermissions - The application permissions.
	AppPermissions *[]string `json:"appPermissions,omitempty"`
	// AvailableToOtherTenants - Whether the application is available to other tenants.
	AvailableToOtherTenants *bool `json:"availableToOtherTenants,omitempty"`
	// ErrorURL - A URL provided by the author of the application to report errors when using the application.
	ErrorURL *string `json:"errorUrl,omitempty"`
	// GroupMembershipClaims - Configures the groups claim issued in a user or OAuth 2.0 access token that the app expects. Possible values include: 'None', 'SecurityGroup', 'All'
	GroupMembershipClaims GroupMembershipClaimTypes `json:"groupMembershipClaims,omitempty"`
	// Homepage - The home page of the application.
	Homepage *string `json:"homepage,omitempty"`
	// InformationalUrls - URLs with more information about the application.
	InformationalUrls *InformationalURL `json:"informationalUrls,omitempty"`
	// IsDeviceOnlyAuthSupported - Specifies whether this application supports device authentication without a user. The default is false.
	IsDeviceOnlyAuthSupported *bool `json:"isDeviceOnlyAuthSupported,omitempty"`
	// KeyCredentials - A collection of KeyCredential objects.
	KeyCredentials *[]KeyCredential `json:"keyCredentials,omitempty"`
	// KnownClientApplications - Client applications that are tied to this resource application. Consent to any of the known client applications will result in implicit consent to the resource application through a combined consent dialog (showing the OAuth permission scopes required by the client and the resource).
	KnownClientApplications *[]string `json:"knownClientApplications,omitempty"`
	// LogoutURL - the url of the logout page
	LogoutURL *string `json:"logoutUrl,omitempty"`
	// Oauth2AllowImplicitFlow - Whether to allow implicit grant flow for OAuth2
	Oauth2AllowImplicitFlow *bool `json:"oauth2AllowImplicitFlow,omitempty"`
	// Oauth2AllowURLPathMatching - Specifies whether during a token Request Azure AD will allow path matching of the redirect URI against the applications collection of replyURLs. The default is false.
	Oauth2AllowURLPathMatching *bool `json:"oauth2AllowUrlPathMatching,omitempty"`
	// Oauth2Permissions - The collection of OAuth 2.0 permission scopes that the web API (resource) application exposes to client applications. These permission scopes may be granted to client applications during consent.
	Oauth2Permissions *[]OAuth2Permission `json:"oauth2Permissions,omitempty"`
	// Oauth2RequirePostResponse - Specifies whether, as part of OAuth 2.0 token requests, Azure AD will allow POST requests, as opposed to GET requests. The default is false, which specifies that only GET requests will be allowed.
	Oauth2RequirePostResponse *bool `json:"oauth2RequirePostResponse,omitempty"`
	// OrgRestrictions - A list of tenants allowed to access application.
	OrgRestrictions *[]string       `json:"orgRestrictions,omitempty"`
	OptionalClaims  *OptionalClaims `json:"optionalClaims,omitempty"`
	// PasswordCredentials - A collection of PasswordCredential objects
	PasswordCredentials *[]PasswordCredential `json:"passwordCredentials,omitempty"`
	// PreAuthorizedApplications - list of pre-authorized applications.
	PreAuthorizedApplications *[]PreAuthorizedApplication `json:"preAuthorizedApplications,omitempty"`
	// PublicClient - Specifies whether this application is a public client (such as an installed application running on a mobile device). Default is false.
	PublicClient *bool `json:"publicClient,omitempty"`
	// PublisherDomain - Reliable domain which can be used to identify an application.
	PublisherDomain *string `json:"publisherDomain,omitempty"`
	// ReplyUrls - A collection of reply URLs for the application.
	ReplyUrls *[]string `json:"replyUrls,omitempty"`
	// RequiredResourceAccess - Specifies resources that this application requires access to and the set of OAuth permission scopes and application roles that it needs under each of those resources. This pre-configuration of required resource access drives the consent experience.
	RequiredResourceAccess *[]RequiredResourceAccess `json:"requiredResourceAccess,omitempty"`
	// SamlMetadataURL - The URL to the SAML metadata for the application.
	SamlMetadataURL *string `json:"samlMetadataUrl,omitempty"`
	// SignInAudience - Audience for signing in to the application (AzureADMyOrganization, AzureADAllOrganizations, AzureADAndMicrosoftAccounts).
	SignInAudience *string `json:"signInAudience,omitempty"`
	// WwwHomepage - The primary Web page.
	WwwHomepage *string `json:"wwwHomepage,omitempty"`
}

// ApplicationListResult application list operation result.
type ApplicationListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of applications.
	Value *[]Application `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// ApplicationListResultIterator provides access to a complete listing of Application values.
type ApplicationListResultIterator struct {
	i    int
	page ApplicationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationListResultIterator) Response() ApplicationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationListResultIterator) Value() Application {
	if !iter.page.NotDone() {
		return Application{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationListResultIterator type.
func NewApplicationListResultIterator(page ApplicationListResultPage) ApplicationListResultIterator {
	return ApplicationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr ApplicationListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr ApplicationListResult) hasNextLink() bool {
	return alr.OdataNextLink != nil && len(*alr.OdataNextLink) != 0
}

// ApplicationListResultPage contains a page of Application values.
type ApplicationListResultPage struct {
	fn  func(context.Context, ApplicationListResult) (ApplicationListResult, error)
	alr ApplicationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationListResultPage) Response() ApplicationListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationListResultPage) Values() []Application {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the ApplicationListResultPage type.
func NewApplicationListResultPage(cur ApplicationListResult, getNextPage func(context.Context, ApplicationListResult) (ApplicationListResult, error)) ApplicationListResultPage {
	return ApplicationListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// ApplicationUpdateParameters request parameters for updating a new application.
type ApplicationUpdateParameters struct {
	// DisplayName - The display name of the application.
	DisplayName *string `json:"displayName,omitempty"`
	// IdentifierUris - A collection of URIs for the application.
	IdentifierUris *[]string `json:"identifierUris,omitempty"`
	// AllowGuestsSignIn - A property on the application to indicate if the application accepts other IDPs or not or partially accepts.
	AllowGuestsSignIn *bool `json:"allowGuestsSignIn,omitempty"`
	// AllowPassthroughUsers - Indicates that the application supports pass through users who have no presence in the resource tenant.
	AllowPassthroughUsers *bool `json:"allowPassthroughUsers,omitempty"`
	// AppLogoURL - The url for the application logo image stored in a CDN.
	AppLogoURL *string `json:"appLogoUrl,omitempty"`
	// AppRoles - The collection of application roles that an application may declare. These roles can be assigned to users, groups or service principals.
	AppRoles *[]AppRole `json:"appRoles,omitempty"`
	// AppPermissions - The application permissions.
	AppPermissions *[]string `json:"appPermissions,omitempty"`
	// AvailableToOtherTenants - Whether the application is available to other tenants.
	AvailableToOtherTenants *bool `json:"availableToOtherTenants,omitempty"`
	// ErrorURL - A URL provided by the author of the application to report errors when using the application.
	ErrorURL *string `json:"errorUrl,omitempty"`
	// GroupMembershipClaims - Configures the groups claim issued in a user or OAuth 2.0 access token that the app expects. Possible values include: 'None', 'SecurityGroup', 'All'
	GroupMembershipClaims GroupMembershipClaimTypes `json:"groupMembershipClaims,omitempty"`
	// Homepage - The home page of the application.
	Homepage *string `json:"homepage,omitempty"`
	// InformationalUrls - URLs with more information about the application.
	InformationalUrls *InformationalURL `json:"informationalUrls,omitempty"`
	// IsDeviceOnlyAuthSupported - Specifies whether this application supports device authentication without a user. The default is false.
	IsDeviceOnlyAuthSupported *bool `json:"isDeviceOnlyAuthSupported,omitempty"`
	// KeyCredentials - A collection of KeyCredential objects.
	KeyCredentials *[]KeyCredential `json:"keyCredentials,omitempty"`
	// KnownClientApplications - Client applications that are tied to this resource application. Consent to any of the known client applications will result in implicit consent to the resource application through a combined consent dialog (showing the OAuth permission scopes required by the client and the resource).
	KnownClientApplications *[]string `json:"knownClientApplications,omitempty"`
	// LogoutURL - the url of the logout page
	LogoutURL *string `json:"logoutUrl,omitempty"`
	// Oauth2AllowImplicitFlow - Whether to allow implicit grant flow for OAuth2
	Oauth2AllowImplicitFlow *bool `json:"oauth2AllowImplicitFlow,omitempty"`
	// Oauth2AllowURLPathMatching - Specifies whether during a token Request Azure AD will allow path matching of the redirect URI against the applications collection of replyURLs. The default is false.
	Oauth2AllowURLPathMatching *bool `json:"oauth2AllowUrlPathMatching,omitempty"`
	// Oauth2Permissions - The collection of OAuth 2.0 permission scopes that the web API (resource) application exposes to client applications. These permission scopes may be granted to client applications during consent.
	Oauth2Permissions *[]OAuth2Permission `json:"oauth2Permissions,omitempty"`
	// Oauth2RequirePostResponse - Specifies whether, as part of OAuth 2.0 token requests, Azure AD will allow POST requests, as opposed to GET requests. The default is false, which specifies that only GET requests will be allowed.
	Oauth2RequirePostResponse *bool `json:"oauth2RequirePostResponse,omitempty"`
	// OrgRestrictions - A list of tenants allowed to access application.
	OrgRestrictions *[]string       `json:"orgRestrictions,omitempty"`
	OptionalClaims  *OptionalClaims `json:"optionalClaims,omitempty"`
	// PasswordCredentials - A collection of PasswordCredential objects
	PasswordCredentials *[]PasswordCredential `json:"passwordCredentials,omitempty"`
	// PreAuthorizedApplications - list of pre-authorized applications.
	PreAuthorizedApplications *[]PreAuthorizedApplication `json:"preAuthorizedApplications,omitempty"`
	// PublicClient - Specifies whether this application is a public client (such as an installed application running on a mobile device). Default is false.
	PublicClient *bool `json:"publicClient,omitempty"`
	// PublisherDomain - Reliable domain which can be used to identify an application.
	PublisherDomain *string `json:"publisherDomain,omitempty"`
	// ReplyUrls - A collection of reply URLs for the application.
	ReplyUrls *[]string `json:"replyUrls,omitempty"`
	// RequiredResourceAccess - Specifies resources that this application requires access to and the set of OAuth permission scopes and application roles that it needs under each of those resources. This pre-configuration of required resource access drives the consent experience.
	RequiredResourceAccess *[]RequiredResourceAccess `json:"requiredResourceAccess,omitempty"`
	// SamlMetadataURL - The URL to the SAML metadata for the application.
	SamlMetadataURL *string `json:"samlMetadataUrl,omitempty"`
	// SignInAudience - Audience for signing in to the application (AzureADMyOrganization, AzureADAllOrganizations, AzureADAndMicrosoftAccounts).
	SignInAudience *string `json:"signInAudience,omitempty"`
	// WwwHomepage - The primary Web page.
	WwwHomepage *string `json:"wwwHomepage,omitempty"`
}

// AppRole ...
type AppRole struct {
	// ID - Unique role identifier inside the appRoles collection.
	ID *string `json:"id,omitempty"`
	// AllowedMemberTypes - Specifies whether this app role definition can be assigned to users and groups by setting to 'User', or to other applications (that are accessing this application in daemon service scenarios) by setting to 'Application', or to both.
	AllowedMemberTypes *[]string `json:"allowedMemberTypes,omitempty"`
	// Description - Permission help text that appears in the admin app assignment and consent experiences.
	Description *string `json:"description,omitempty"`
	// DisplayName - Display name for the permission that appears in the admin consent and app assignment experiences.
	DisplayName *string `json:"displayName,omitempty"`
	// IsEnabled - When creating or updating a role definition, this must be set to true (which is the default). To delete a role, this must first be set to false. At that point, in a subsequent call, this role may be removed.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// Value - Specifies the value of the roles claim that the application should expect in the authentication and access tokens.
	Value *string `json:"value,omitempty"`
}

// CheckGroupMembershipParameters request parameters for IsMemberOf API call.
type CheckGroupMembershipParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// GroupID - The object ID of the group to check.
	GroupID *string `json:"groupId,omitempty"`
	// MemberID - The object ID of the contact, group, user, or service principal to check for membership in the specified group.
	MemberID *string `json:"memberId,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckGroupMembershipParameters.
func (cgmp CheckGroupMembershipParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cgmp.GroupID != nil {
		objectMap["groupId"] = cgmp.GroupID
	}
	if cgmp.MemberID != nil {
		objectMap["memberId"] = cgmp.MemberID
	}
	for k, v := range cgmp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CheckGroupMembershipParameters struct.
func (cgmp *CheckGroupMembershipParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if cgmp.AdditionalProperties == nil {
					cgmp.AdditionalProperties = make(map[string]interface{})
				}
				cgmp.AdditionalProperties[k] = additionalProperties
			}
		case "groupId":
			if v != nil {
				var groupID string
				err = json.Unmarshal(*v, &groupID)
				if err != nil {
					return err
				}
				cgmp.GroupID = &groupID
			}
		case "memberId":
			if v != nil {
				var memberID string
				err = json.Unmarshal(*v, &memberID)
				if err != nil {
					return err
				}
				cgmp.MemberID = &memberID
			}
		}
	}

	return nil
}

// CheckGroupMembershipResult server response for IsMemberOf API call
type CheckGroupMembershipResult struct {
	autorest.Response `json:"-"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Value - True if the specified user, group, contact, or service principal has either direct or transitive membership in the specified group; otherwise, false.
	Value *bool `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckGroupMembershipResult.
func (cgmr CheckGroupMembershipResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cgmr.Value != nil {
		objectMap["value"] = cgmr.Value
	}
	for k, v := range cgmr.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CheckGroupMembershipResult struct.
func (cgmr *CheckGroupMembershipResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if cgmr.AdditionalProperties == nil {
					cgmr.AdditionalProperties = make(map[string]interface{})
				}
				cgmr.AdditionalProperties[k] = additionalProperties
			}
		case "value":
			if v != nil {
				var value bool
				err = json.Unmarshal(*v, &value)
				if err != nil {
					return err
				}
				cgmr.Value = &value
			}
		}
	}

	return nil
}

// BasicDirectoryObject represents an Azure Active Directory object.
type BasicDirectoryObject interface {
	AsApplication() (*Application, bool)
	AsADGroup() (*ADGroup, bool)
	AsServicePrincipal() (*ServicePrincipal, bool)
	AsUser() (*User, bool)
	AsDirectoryObject() (*DirectoryObject, bool)
}

// DirectoryObject represents an Azure Active Directory object.
type DirectoryObject struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ObjectID - READ-ONLY; The object ID.
	ObjectID *string `json:"objectId,omitempty"`
	// DeletionTimestamp - READ-ONLY; The time at which the directory object was deleted.
	DeletionTimestamp *date.Time `json:"deletionTimestamp,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeDirectoryObject', 'ObjectTypeApplication', 'ObjectTypeGroup', 'ObjectTypeServicePrincipal', 'ObjectTypeUser'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

func unmarshalBasicDirectoryObject(body []byte) (BasicDirectoryObject, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeApplication):
		var a Application
		err := json.Unmarshal(body, &a)
		return a, err
	case string(ObjectTypeGroup):
		var ag ADGroup
		err := json.Unmarshal(body, &ag)
		return ag, err
	case string(ObjectTypeServicePrincipal):
		var sp ServicePrincipal
		err := json.Unmarshal(body, &sp)
		return sp, err
	case string(ObjectTypeUser):
		var u User
		err := json.Unmarshal(body, &u)
		return u, err
	default:
		var do DirectoryObject
		err := json.Unmarshal(body, &do)
		return do, err
	}
}
func unmarshalBasicDirectoryObjectArray(body []byte) ([]BasicDirectoryObject, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	doArray := make([]BasicDirectoryObject, len(rawMessages))

	for index, rawMessage := range rawMessages {
		do, err := unmarshalBasicDirectoryObject(*rawMessage)
		if err != nil {
			return nil, err
		}
		doArray[index] = do
	}
	return doArray, nil
}

// MarshalJSON is the custom marshaler for DirectoryObject.
func (do DirectoryObject) MarshalJSON() ([]byte, error) {
	do.ObjectType = ObjectTypeDirectoryObject
	objectMap := make(map[string]interface{})
	if do.ObjectType != "" {
		objectMap["objectType"] = do.ObjectType
	}
	for k, v := range do.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsApplication is the BasicDirectoryObject implementation for DirectoryObject.
func (do DirectoryObject) AsApplication() (*Application, bool) {
	return nil, false
}

// AsADGroup is the BasicDirectoryObject implementation for DirectoryObject.
func (do DirectoryObject) AsADGroup() (*ADGroup, bool) {
	return nil, false
}

// AsServicePrincipal is the BasicDirectoryObject implementation for DirectoryObject.
func (do DirectoryObject) AsServicePrincipal() (*ServicePrincipal, bool) {
	return nil, false
}

// AsUser is the BasicDirectoryObject implementation for DirectoryObject.
func (do DirectoryObject) AsUser() (*User, bool) {
	return nil, false
}

// AsDirectoryObject is the BasicDirectoryObject implementation for DirectoryObject.
func (do DirectoryObject) AsDirectoryObject() (*DirectoryObject, bool) {
	return &do, true
}

// AsBasicDirectoryObject is the BasicDirectoryObject implementation for DirectoryObject.
func (do DirectoryObject) AsBasicDirectoryObject() (BasicDirectoryObject, bool) {
	return &do, true
}

// UnmarshalJSON is the custom unmarshaler for DirectoryObject struct.
func (do *DirectoryObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if do.AdditionalProperties == nil {
					do.AdditionalProperties = make(map[string]interface{})
				}
				do.AdditionalProperties[k] = additionalProperties
			}
		case "objectId":
			if v != nil {
				var objectID string
				err = json.Unmarshal(*v, &objectID)
				if err != nil {
					return err
				}
				do.ObjectID = &objectID
			}
		case "deletionTimestamp":
			if v != nil {
				var deletionTimestamp date.Time
				err = json.Unmarshal(*v, &deletionTimestamp)
				if err != nil {
					return err
				}
				do.DeletionTimestamp = &deletionTimestamp
			}
		case "objectType":
			if v != nil {
				var objectType ObjectType
				err = json.Unmarshal(*v, &objectType)
				if err != nil {
					return err
				}
				do.ObjectType = objectType
			}
		}
	}

	return nil
}

// DirectoryObjectListResult directoryObject list operation result.
type DirectoryObjectListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of DirectoryObject.
	Value *[]BasicDirectoryObject `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DirectoryObjectListResult struct.
func (dolr *DirectoryObjectListResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicDirectoryObjectArray(*v)
				if err != nil {
					return err
				}
				dolr.Value = &value
			}
		case "odata.nextLink":
			if v != nil {
				var odataNextLink string
				err = json.Unmarshal(*v, &odataNextLink)
				if err != nil {
					return err
				}
				dolr.OdataNextLink = &odataNextLink
			}
		}
	}

	return nil
}

// DirectoryObjectListResultIterator provides access to a complete listing of DirectoryObject values.
type DirectoryObjectListResultIterator struct {
	i    int
	page DirectoryObjectListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DirectoryObjectListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DirectoryObjectListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DirectoryObjectListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DirectoryObjectListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DirectoryObjectListResultIterator) Response() DirectoryObjectListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DirectoryObjectListResultIterator) Value() BasicDirectoryObject {
	if !iter.page.NotDone() {
		return DirectoryObject{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DirectoryObjectListResultIterator type.
func NewDirectoryObjectListResultIterator(page DirectoryObjectListResultPage) DirectoryObjectListResultIterator {
	return DirectoryObjectListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dolr DirectoryObjectListResult) IsEmpty() bool {
	return dolr.Value == nil || len(*dolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dolr DirectoryObjectListResult) hasNextLink() bool {
	return dolr.OdataNextLink != nil && len(*dolr.OdataNextLink) != 0
}

// directoryObjectListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dolr DirectoryObjectListResult) directoryObjectListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dolr.OdataNextLink)))
}

// DirectoryObjectListResultPage contains a page of BasicDirectoryObject values.
type DirectoryObjectListResultPage struct {
	fn   func(context.Context, DirectoryObjectListResult) (DirectoryObjectListResult, error)
	dolr DirectoryObjectListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DirectoryObjectListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DirectoryObjectListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dolr)
		if err != nil {
			return err
		}
		page.dolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DirectoryObjectListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DirectoryObjectListResultPage) NotDone() bool {
	return !page.dolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DirectoryObjectListResultPage) Response() DirectoryObjectListResult {
	return page.dolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DirectoryObjectListResultPage) Values() []BasicDirectoryObject {
	if page.dolr.IsEmpty() {
		return nil
	}
	return *page.dolr.Value
}

// Creates a new instance of the DirectoryObjectListResultPage type.
func NewDirectoryObjectListResultPage(cur DirectoryObjectListResult, getNextPage func(context.Context, DirectoryObjectListResult) (DirectoryObjectListResult, error)) DirectoryObjectListResultPage {
	return DirectoryObjectListResultPage{
		fn:   getNextPage,
		dolr: cur,
	}
}

// Domain active Directory Domain information.
type Domain struct {
	autorest.Response `json:"-"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// AuthenticationType - READ-ONLY; the type of the authentication into the domain.
	AuthenticationType *string `json:"authenticationType,omitempty"`
	// IsDefault - READ-ONLY; if this is the default domain in the tenant.
	IsDefault *bool `json:"isDefault,omitempty"`
	// IsVerified - READ-ONLY; if this domain's ownership is verified.
	IsVerified *bool `json:"isVerified,omitempty"`
	// Name - the domain name.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Domain.
func (d Domain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.Name != nil {
		objectMap["name"] = d.Name
	}
	for k, v := range d.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Domain struct.
func (d *Domain) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if d.AdditionalProperties == nil {
					d.AdditionalProperties = make(map[string]interface{})
				}
				d.AdditionalProperties[k] = additionalProperties
			}
		case "authenticationType":
			if v != nil {
				var authenticationType string
				err = json.Unmarshal(*v, &authenticationType)
				if err != nil {
					return err
				}
				d.AuthenticationType = &authenticationType
			}
		case "isDefault":
			if v != nil {
				var isDefault bool
				err = json.Unmarshal(*v, &isDefault)
				if err != nil {
					return err
				}
				d.IsDefault = &isDefault
			}
		case "isVerified":
			if v != nil {
				var isVerified bool
				err = json.Unmarshal(*v, &isVerified)
				if err != nil {
					return err
				}
				d.IsVerified = &isVerified
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		}
	}

	return nil
}

// DomainListResult server response for Get tenant domains API call.
type DomainListResult struct {
	autorest.Response `json:"-"`
	// Value - the list of domains.
	Value *[]Domain `json:"value,omitempty"`
}

// ErrorMessage active Directory error message.
type ErrorMessage struct {
	// Message - Error message value.
	Message *string `json:"value,omitempty"`
}

// GetObjectsParameters request parameters for the GetObjectsByObjectIds API.
type GetObjectsParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ObjectIds - The requested object IDs.
	ObjectIds *[]string `json:"objectIds,omitempty"`
	// Types - The requested object types.
	Types *[]string `json:"types,omitempty"`
	// IncludeDirectoryObjectReferences - If true, also searches for object IDs in the partner tenant.
	IncludeDirectoryObjectReferences *bool `json:"includeDirectoryObjectReferences,omitempty"`
}

// MarshalJSON is the custom marshaler for GetObjectsParameters.
func (gop GetObjectsParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gop.ObjectIds != nil {
		objectMap["objectIds"] = gop.ObjectIds
	}
	if gop.Types != nil {
		objectMap["types"] = gop.Types
	}
	if gop.IncludeDirectoryObjectReferences != nil {
		objectMap["includeDirectoryObjectReferences"] = gop.IncludeDirectoryObjectReferences
	}
	for k, v := range gop.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GetObjectsParameters struct.
func (gop *GetObjectsParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if gop.AdditionalProperties == nil {
					gop.AdditionalProperties = make(map[string]interface{})
				}
				gop.AdditionalProperties[k] = additionalProperties
			}
		case "objectIds":
			if v != nil {
				var objectIds []string
				err = json.Unmarshal(*v, &objectIds)
				if err != nil {
					return err
				}
				gop.ObjectIds = &objectIds
			}
		case "types":
			if v != nil {
				var typesVar []string
				err = json.Unmarshal(*v, &typesVar)
				if err != nil {
					return err
				}
				gop.Types = &typesVar
			}
		case "includeDirectoryObjectReferences":
			if v != nil {
				var includeDirectoryObjectReferences bool
				err = json.Unmarshal(*v, &includeDirectoryObjectReferences)
				if err != nil {
					return err
				}
				gop.IncludeDirectoryObjectReferences = &includeDirectoryObjectReferences
			}
		}
	}

	return nil
}

// GraphError active Directory error information.
type GraphError struct {
	// OdataError - A Graph API error.
	*OdataError `json:"odata.error,omitempty"`
}

// MarshalJSON is the custom marshaler for GraphError.
func (ge GraphError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ge.OdataError != nil {
		objectMap["odata.error"] = ge.OdataError
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GraphError struct.
func (ge *GraphError) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "odata.error":
			if v != nil {
				var odataError OdataError
				err = json.Unmarshal(*v, &odataError)
				if err != nil {
					return err
				}
				ge.OdataError = &odataError
			}
		}
	}

	return nil
}

// GroupAddMemberParameters request parameters for adding a member to a group.
type GroupAddMemberParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// URL - A member object URL, such as "https://graph.windows.net/0b1f9851-1bf0-433f-aec3-cb9272f093dc/directoryObjects/f260bbc4-c254-447b-94cf-293b5ec434dd", where "0b1f9851-1bf0-433f-aec3-cb9272f093dc" is the tenantId and "f260bbc4-c254-447b-94cf-293b5ec434dd" is the objectId of the member (user, application, servicePrincipal, group) to be added.
	URL *string `json:"url,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupAddMemberParameters.
func (gamp GroupAddMemberParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gamp.URL != nil {
		objectMap["url"] = gamp.URL
	}
	for k, v := range gamp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GroupAddMemberParameters struct.
func (gamp *GroupAddMemberParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if gamp.AdditionalProperties == nil {
					gamp.AdditionalProperties = make(map[string]interface{})
				}
				gamp.AdditionalProperties[k] = additionalProperties
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				gamp.URL = &URL
			}
		}
	}

	return nil
}

// GroupCreateParameters request parameters for creating a new group.
type GroupCreateParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// DisplayName - Group display name
	DisplayName *string `json:"displayName,omitempty"`
	// MailEnabled - Whether the group is mail-enabled. Must be false. This is because only pure security groups can be created using the Graph API.
	MailEnabled *bool `json:"mailEnabled,omitempty"`
	// MailNickname - Mail nickname
	MailNickname *string `json:"mailNickname,omitempty"`
	// SecurityEnabled - Whether the group is a security group. Must be true. This is because only pure security groups can be created using the Graph API.
	SecurityEnabled *bool `json:"securityEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupCreateParameters.
func (gcp GroupCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gcp.DisplayName != nil {
		objectMap["displayName"] = gcp.DisplayName
	}
	if gcp.MailEnabled != nil {
		objectMap["mailEnabled"] = gcp.MailEnabled
	}
	if gcp.MailNickname != nil {
		objectMap["mailNickname"] = gcp.MailNickname
	}
	if gcp.SecurityEnabled != nil {
		objectMap["securityEnabled"] = gcp.SecurityEnabled
	}
	for k, v := range gcp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GroupCreateParameters struct.
func (gcp *GroupCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if gcp.AdditionalProperties == nil {
					gcp.AdditionalProperties = make(map[string]interface{})
				}
				gcp.AdditionalProperties[k] = additionalProperties
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				gcp.DisplayName = &displayName
			}
		case "mailEnabled":
			if v != nil {
				var mailEnabled bool
				err = json.Unmarshal(*v, &mailEnabled)
				if err != nil {
					return err
				}
				gcp.MailEnabled = &mailEnabled
			}
		case "mailNickname":
			if v != nil {
				var mailNickname string
				err = json.Unmarshal(*v, &mailNickname)
				if err != nil {
					return err
				}
				gcp.MailNickname = &mailNickname
			}
		case "securityEnabled":
			if v != nil {
				var securityEnabled bool
				err = json.Unmarshal(*v, &securityEnabled)
				if err != nil {
					return err
				}
				gcp.SecurityEnabled = &securityEnabled
			}
		}
	}

	return nil
}

// GroupGetMemberGroupsParameters request parameters for GetMemberGroups API call.
type GroupGetMemberGroupsParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SecurityEnabledOnly - If true, only membership in security-enabled groups should be checked. Otherwise, membership in all groups should be checked.
	SecurityEnabledOnly *bool `json:"securityEnabledOnly,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupGetMemberGroupsParameters.
func (ggmgp GroupGetMemberGroupsParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ggmgp.SecurityEnabledOnly != nil {
		objectMap["securityEnabledOnly"] = ggmgp.SecurityEnabledOnly
	}
	for k, v := range ggmgp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GroupGetMemberGroupsParameters struct.
func (ggmgp *GroupGetMemberGroupsParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ggmgp.AdditionalProperties == nil {
					ggmgp.AdditionalProperties = make(map[string]interface{})
				}
				ggmgp.AdditionalProperties[k] = additionalProperties
			}
		case "securityEnabledOnly":
			if v != nil {
				var securityEnabledOnly bool
				err = json.Unmarshal(*v, &securityEnabledOnly)
				if err != nil {
					return err
				}
				ggmgp.SecurityEnabledOnly = &securityEnabledOnly
			}
		}
	}

	return nil
}

// GroupGetMemberGroupsResult server response for GetMemberGroups API call.
type GroupGetMemberGroupsResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of group IDs of which the group is a member.
	Value *[]string `json:"value,omitempty"`
}

// GroupListResult server response for Get tenant groups API call
type GroupListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of Active Directory groups.
	Value *[]ADGroup `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// GroupListResultIterator provides access to a complete listing of ADGroup values.
type GroupListResultIterator struct {
	i    int
	page GroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GroupListResultIterator) Response() GroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GroupListResultIterator) Value() ADGroup {
	if !iter.page.NotDone() {
		return ADGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GroupListResultIterator type.
func NewGroupListResultIterator(page GroupListResultPage) GroupListResultIterator {
	return GroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (glr GroupListResult) IsEmpty() bool {
	return glr.Value == nil || len(*glr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (glr GroupListResult) hasNextLink() bool {
	return glr.OdataNextLink != nil && len(*glr.OdataNextLink) != 0
}

// GroupListResultPage contains a page of ADGroup values.
type GroupListResultPage struct {
	fn  func(context.Context, GroupListResult) (GroupListResult, error)
	glr GroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.glr)
		if err != nil {
			return err
		}
		page.glr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GroupListResultPage) NotDone() bool {
	return !page.glr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GroupListResultPage) Response() GroupListResult {
	return page.glr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GroupListResultPage) Values() []ADGroup {
	if page.glr.IsEmpty() {
		return nil
	}
	return *page.glr.Value
}

// Creates a new instance of the GroupListResultPage type.
func NewGroupListResultPage(cur GroupListResult, getNextPage func(context.Context, GroupListResult) (GroupListResult, error)) GroupListResultPage {
	return GroupListResultPage{
		fn:  getNextPage,
		glr: cur,
	}
}

// InformationalURL represents a group of URIs that provide terms of service, marketing, support and
// privacy policy information about an application. The default value for each string is null.
type InformationalURL struct {
	// TermsOfService - The terms of service URI
	TermsOfService *string `json:"termsOfService,omitempty"`
	// Marketing - The marketing URI
	Marketing *string `json:"marketing,omitempty"`
	// Privacy - The privacy policy URI
	Privacy *string `json:"privacy,omitempty"`
	// Support - The support URI
	Support *string `json:"support,omitempty"`
}

// KeyCredential active Directory Key Credential information.
type KeyCredential struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// StartDate - Start date.
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - End date.
	EndDate *date.Time `json:"endDate,omitempty"`
	// Value - Key value.
	Value *string `json:"value,omitempty"`
	// KeyID - Key ID.
	KeyID *string `json:"keyId,omitempty"`
	// Usage - Usage. Acceptable values are 'Verify' and 'Sign'.
	Usage *string `json:"usage,omitempty"`
	// Type - Type. Acceptable values are 'AsymmetricX509Cert' and 'Symmetric'.
	Type *string `json:"type,omitempty"`
	// CustomKeyIdentifier - Custom Key Identifier
	CustomKeyIdentifier *string `json:"customKeyIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyCredential.
func (kc KeyCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kc.StartDate != nil {
		objectMap["startDate"] = kc.StartDate
	}
	if kc.EndDate != nil {
		objectMap["endDate"] = kc.EndDate
	}
	if kc.Value != nil {
		objectMap["value"] = kc.Value
	}
	if kc.KeyID != nil {
		objectMap["keyId"] = kc.KeyID
	}
	if kc.Usage != nil {
		objectMap["usage"] = kc.Usage
	}
	if kc.Type != nil {
		objectMap["type"] = kc.Type
	}
	if kc.CustomKeyIdentifier != nil {
		objectMap["customKeyIdentifier"] = kc.CustomKeyIdentifier
	}
	for k, v := range kc.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for KeyCredential struct.
func (kc *KeyCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if kc.AdditionalProperties == nil {
					kc.AdditionalProperties = make(map[string]interface{})
				}
				kc.AdditionalProperties[k] = additionalProperties
			}
		case "startDate":
			if v != nil {
				var startDate date.Time
				err = json.Unmarshal(*v, &startDate)
				if err != nil {
					return err
				}
				kc.StartDate = &startDate
			}
		case "endDate":
			if v != nil {
				var endDate date.Time
				err = json.Unmarshal(*v, &endDate)
				if err != nil {
					return err
				}
				kc.EndDate = &endDate
			}
		case "value":
			if v != nil {
				var value string
				err = json.Unmarshal(*v, &value)
				if err != nil {
					return err
				}
				kc.Value = &value
			}
		case "keyId":
			if v != nil {
				var keyID string
				err = json.Unmarshal(*v, &keyID)
				if err != nil {
					return err
				}
				kc.KeyID = &keyID
			}
		case "usage":
			if v != nil {
				var usage string
				err = json.Unmarshal(*v, &usage)
				if err != nil {
					return err
				}
				kc.Usage = &usage
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				kc.Type = &typeVar
			}
		case "customKeyIdentifier":
			if v != nil {
				var customKeyIdentifier string
				err = json.Unmarshal(*v, &customKeyIdentifier)
				if err != nil {
					return err
				}
				kc.CustomKeyIdentifier = &customKeyIdentifier
			}
		}
	}

	return nil
}

// KeyCredentialListResult keyCredential list operation result.
type KeyCredentialListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of KeyCredentials.
	Value *[]KeyCredential `json:"value,omitempty"`
}

// KeyCredentialsUpdateParameters request parameters for a KeyCredentials update operation
type KeyCredentialsUpdateParameters struct {
	// Value - A collection of KeyCredentials.
	Value *[]KeyCredential `json:"value,omitempty"`
}

// OAuth2Permission represents an OAuth 2.0 delegated permission scope. The specified OAuth 2.0 delegated
// permission scopes may be requested by client applications (through the requiredResourceAccess collection
// on the Application object) when calling a resource application. The oauth2Permissions property of the
// ServicePrincipal entity and of the Application entity is a collection of OAuth2Permission.
type OAuth2Permission struct {
	// AdminConsentDescription - Permission help text that appears in the admin consent and app assignment experiences.
	AdminConsentDescription *string `json:"adminConsentDescription,omitempty"`
	// AdminConsentDisplayName - Display name for the permission that appears in the admin consent and app assignment experiences.
	AdminConsentDisplayName *string `json:"adminConsentDisplayName,omitempty"`
	// ID - Unique scope permission identifier inside the oauth2Permissions collection.
	ID *string `json:"id,omitempty"`
	// IsEnabled - When creating or updating a permission, this property must be set to true (which is the default). To delete a permission, this property must first be set to false. At that point, in a subsequent call, the permission may be removed.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// Type - Specifies whether this scope permission can be consented to by an end user, or whether it is a tenant-wide permission that must be consented to by a Company Administrator. Possible values are "User" or "Admin".
	Type *string `json:"type,omitempty"`
	// UserConsentDescription - Permission help text that appears in the end user consent experience.
	UserConsentDescription *string `json:"userConsentDescription,omitempty"`
	// UserConsentDisplayName - Display name for the permission that appears in the end user consent experience.
	UserConsentDisplayName *string `json:"userConsentDisplayName,omitempty"`
	// Value - The value of the scope claim that the resource application should expect in the OAuth 2.0 access token.
	Value *string `json:"value,omitempty"`
}

// OAuth2PermissionGrant ...
type OAuth2PermissionGrant struct {
	autorest.Response `json:"-"`
	// OdataType - Microsoft.DirectoryServices.OAuth2PermissionGrant
	OdataType *string `json:"odata.type,omitempty"`
	// ClientID - The id of the resource's service principal granted consent to impersonate the user when accessing the resource (represented by the resourceId property).
	ClientID *string `json:"clientId,omitempty"`
	// ObjectID - The id of the permission grant
	ObjectID *string `json:"objectId,omitempty"`
	// ConsentType - Indicates if consent was provided by the administrator (on behalf of the organization) or by an individual. Possible values include: 'AllPrincipals', 'Principal'
	ConsentType ConsentType `json:"consentType,omitempty"`
	// PrincipalID - When consent type is Principal, this property specifies the id of the user that granted consent and applies only for that user.
	PrincipalID *string `json:"principalId,omitempty"`
	// ResourceID - Object Id of the resource you want to grant
	ResourceID *string `json:"resourceId,omitempty"`
	// Scope - Specifies the value of the scope claim that the resource application should expect in the OAuth 2.0 access token. For example, User.Read
	Scope *string `json:"scope,omitempty"`
	// StartTime - Start time for TTL
	StartTime *string `json:"startTime,omitempty"`
	// ExpiryTime - Expiry time for TTL
	ExpiryTime *string `json:"expiryTime,omitempty"`
}

// OAuth2PermissionGrantListResult server response for get oauth2 permissions grants
type OAuth2PermissionGrantListResult struct {
	autorest.Response `json:"-"`
	// Value - the list of oauth2 permissions grants
	Value *[]OAuth2PermissionGrant `json:"value,omitempty"`
	// OdataNextLink - the URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// OAuth2PermissionGrantListResultIterator provides access to a complete listing of OAuth2PermissionGrant
// values.
type OAuth2PermissionGrantListResultIterator struct {
	i    int
	page OAuth2PermissionGrantListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OAuth2PermissionGrantListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OAuth2PermissionGrantListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OAuth2PermissionGrantListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OAuth2PermissionGrantListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OAuth2PermissionGrantListResultIterator) Response() OAuth2PermissionGrantListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OAuth2PermissionGrantListResultIterator) Value() OAuth2PermissionGrant {
	if !iter.page.NotDone() {
		return OAuth2PermissionGrant{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OAuth2PermissionGrantListResultIterator type.
func NewOAuth2PermissionGrantListResultIterator(page OAuth2PermissionGrantListResultPage) OAuth2PermissionGrantListResultIterator {
	return OAuth2PermissionGrantListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oa2pglr OAuth2PermissionGrantListResult) IsEmpty() bool {
	return oa2pglr.Value == nil || len(*oa2pglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oa2pglr OAuth2PermissionGrantListResult) hasNextLink() bool {
	return oa2pglr.OdataNextLink != nil && len(*oa2pglr.OdataNextLink) != 0
}

// OAuth2PermissionGrantListResultPage contains a page of OAuth2PermissionGrant values.
type OAuth2PermissionGrantListResultPage struct {
	fn      func(context.Context, OAuth2PermissionGrantListResult) (OAuth2PermissionGrantListResult, error)
	oa2pglr OAuth2PermissionGrantListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OAuth2PermissionGrantListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OAuth2PermissionGrantListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oa2pglr)
		if err != nil {
			return err
		}
		page.oa2pglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OAuth2PermissionGrantListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OAuth2PermissionGrantListResultPage) NotDone() bool {
	return !page.oa2pglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OAuth2PermissionGrantListResultPage) Response() OAuth2PermissionGrantListResult {
	return page.oa2pglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OAuth2PermissionGrantListResultPage) Values() []OAuth2PermissionGrant {
	if page.oa2pglr.IsEmpty() {
		return nil
	}
	return *page.oa2pglr.Value
}

// Creates a new instance of the OAuth2PermissionGrantListResultPage type.
func NewOAuth2PermissionGrantListResultPage(cur OAuth2PermissionGrantListResult, getNextPage func(context.Context, OAuth2PermissionGrantListResult) (OAuth2PermissionGrantListResult, error)) OAuth2PermissionGrantListResultPage {
	return OAuth2PermissionGrantListResultPage{
		fn:      getNextPage,
		oa2pglr: cur,
	}
}

// OdataError active Directory OData error information.
type OdataError struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// ErrorMessage - Error Message.
	*ErrorMessage `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for OdataError.
func (oe OdataError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oe.Code != nil {
		objectMap["code"] = oe.Code
	}
	if oe.ErrorMessage != nil {
		objectMap["message"] = oe.ErrorMessage
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OdataError struct.
func (oe *OdataError) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "code":
			if v != nil {
				var code string
				err = json.Unmarshal(*v, &code)
				if err != nil {
					return err
				}
				oe.Code = &code
			}
		case "message":
			if v != nil {
				var errorMessage ErrorMessage
				err = json.Unmarshal(*v, &errorMessage)
				if err != nil {
					return err
				}
				oe.ErrorMessage = &errorMessage
			}
		}
	}

	return nil
}

// OptionalClaim specifying the claims to be included in a token.
type OptionalClaim struct {
	// Name - Claim name.
	Name *string `json:"name,omitempty"`
	// Source - Claim source.
	Source *string `json:"source,omitempty"`
	// Essential - Is this a required claim.
	Essential            *bool       `json:"essential,omitempty"`
	AdditionalProperties interface{} `json:"additionalProperties,omitempty"`
}

// OptionalClaims specifying the claims to be included in the token.
type OptionalClaims struct {
	// IDToken - Optional claims requested to be included in the id token.
	IDToken *[]OptionalClaim `json:"idToken,omitempty"`
	// AccessToken - Optional claims requested to be included in the access token.
	AccessToken *[]OptionalClaim `json:"accessToken,omitempty"`
	// SamlToken - Optional claims requested to be included in the saml token.
	SamlToken *[]OptionalClaim `json:"samlToken,omitempty"`
}

// PasswordCredential active Directory Password Credential information.
type PasswordCredential struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// StartDate - Start date.
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - End date.
	EndDate *date.Time `json:"endDate,omitempty"`
	// KeyID - Key ID.
	KeyID *string `json:"keyId,omitempty"`
	// Value - Key value.
	Value *string `json:"value,omitempty"`
	// CustomKeyIdentifier - Custom Key Identifier
	CustomKeyIdentifier *[]byte `json:"customKeyIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for PasswordCredential.
func (pc PasswordCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.StartDate != nil {
		objectMap["startDate"] = pc.StartDate
	}
	if pc.EndDate != nil {
		objectMap["endDate"] = pc.EndDate
	}
	if pc.KeyID != nil {
		objectMap["keyId"] = pc.KeyID
	}
	if pc.Value != nil {
		objectMap["value"] = pc.Value
	}
	if pc.CustomKeyIdentifier != nil {
		objectMap["customKeyIdentifier"] = pc.CustomKeyIdentifier
	}
	for k, v := range pc.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PasswordCredential struct.
func (pc *PasswordCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if pc.AdditionalProperties == nil {
					pc.AdditionalProperties = make(map[string]interface{})
				}
				pc.AdditionalProperties[k] = additionalProperties
			}
		case "startDate":
			if v != nil {
				var startDate date.Time
				err = json.Unmarshal(*v, &startDate)
				if err != nil {
					return err
				}
				pc.StartDate = &startDate
			}
		case "endDate":
			if v != nil {
				var endDate date.Time
				err = json.Unmarshal(*v, &endDate)
				if err != nil {
					return err
				}
				pc.EndDate = &endDate
			}
		case "keyId":
			if v != nil {
				var keyID string
				err = json.Unmarshal(*v, &keyID)
				if err != nil {
					return err
				}
				pc.KeyID = &keyID
			}
		case "value":
			if v != nil {
				var value string
				err = json.Unmarshal(*v, &value)
				if err != nil {
					return err
				}
				pc.Value = &value
			}
		case "customKeyIdentifier":
			if v != nil {
				var customKeyIdentifier []byte
				err = json.Unmarshal(*v, &customKeyIdentifier)
				if err != nil {
					return err
				}
				pc.CustomKeyIdentifier = &customKeyIdentifier
			}
		}
	}

	return nil
}

// PasswordCredentialListResult passwordCredential list operation result.
type PasswordCredentialListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of PasswordCredentials.
	Value *[]PasswordCredential `json:"value,omitempty"`
}

// PasswordCredentialsUpdateParameters request parameters for a PasswordCredentials update operation.
type PasswordCredentialsUpdateParameters struct {
	// Value - A collection of PasswordCredentials.
	Value *[]PasswordCredential `json:"value,omitempty"`
}

// PasswordProfile the password profile associated with a user.
type PasswordProfile struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Password - Password
	Password *string `json:"password,omitempty"`
	// ForceChangePasswordNextLogin - Whether to force a password change on next login.
	ForceChangePasswordNextLogin *bool `json:"forceChangePasswordNextLogin,omitempty"`
}

// MarshalJSON is the custom marshaler for PasswordProfile.
func (pp PasswordProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.Password != nil {
		objectMap["password"] = pp.Password
	}
	if pp.ForceChangePasswordNextLogin != nil {
		objectMap["forceChangePasswordNextLogin"] = pp.ForceChangePasswordNextLogin
	}
	for k, v := range pp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PasswordProfile struct.
func (pp *PasswordProfile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if pp.AdditionalProperties == nil {
					pp.AdditionalProperties = make(map[string]interface{})
				}
				pp.AdditionalProperties[k] = additionalProperties
			}
		case "password":
			if v != nil {
				var password string
				err = json.Unmarshal(*v, &password)
				if err != nil {
					return err
				}
				pp.Password = &password
			}
		case "forceChangePasswordNextLogin":
			if v != nil {
				var forceChangePasswordNextLogin bool
				err = json.Unmarshal(*v, &forceChangePasswordNextLogin)
				if err != nil {
					return err
				}
				pp.ForceChangePasswordNextLogin = &forceChangePasswordNextLogin
			}
		}
	}

	return nil
}

// PreAuthorizedApplication contains information about pre authorized client application.
type PreAuthorizedApplication struct {
	// AppID - Represents the application id.
	AppID *string `json:"appId,omitempty"`
	// Permissions - Collection of required app permissions/entitlements from the resource application.
	Permissions *[]PreAuthorizedApplicationPermission `json:"permissions,omitempty"`
	// Extensions - Collection of extensions from the resource application.
	Extensions *[]PreAuthorizedApplicationExtension `json:"extensions,omitempty"`
}

// PreAuthorizedApplicationExtension representation of an app PreAuthorizedApplicationExtension required by
// a pre authorized client app.
type PreAuthorizedApplicationExtension struct {
	// Conditions - The extension's conditions.
	Conditions *[]string `json:"conditions,omitempty"`
}

// PreAuthorizedApplicationPermission contains information about the pre-authorized permissions.
type PreAuthorizedApplicationPermission struct {
	// DirectAccessGrant - Indicates whether the permission set is DirectAccess or impersonation.
	DirectAccessGrant *bool `json:"directAccessGrant,omitempty"`
	// AccessGrants - The list of permissions.
	AccessGrants *[]string `json:"accessGrants,omitempty"`
}

// RequiredResourceAccess specifies the set of OAuth 2.0 permission scopes and app roles under the
// specified resource that an application requires access to. The specified OAuth 2.0 permission scopes may
// be requested by client applications (through the requiredResourceAccess collection) when calling a
// resource application. The requiredResourceAccess property of the Application entity is a collection of
// RequiredResourceAccess.
type RequiredResourceAccess struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ResourceAccess - The list of OAuth2.0 permission scopes and app roles that the application requires from the specified resource.
	ResourceAccess *[]ResourceAccess `json:"resourceAccess,omitempty"`
	// ResourceAppID - The unique identifier for the resource that the application requires access to. This should be equal to the appId declared on the target resource application.
	ResourceAppID *string `json:"resourceAppId,omitempty"`
}

// MarshalJSON is the custom marshaler for RequiredResourceAccess.
func (rra RequiredResourceAccess) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rra.ResourceAccess != nil {
		objectMap["resourceAccess"] = rra.ResourceAccess
	}
	if rra.ResourceAppID != nil {
		objectMap["resourceAppId"] = rra.ResourceAppID
	}
	for k, v := range rra.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RequiredResourceAccess struct.
func (rra *RequiredResourceAccess) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if rra.AdditionalProperties == nil {
					rra.AdditionalProperties = make(map[string]interface{})
				}
				rra.AdditionalProperties[k] = additionalProperties
			}
		case "resourceAccess":
			if v != nil {
				var resourceAccess []ResourceAccess
				err = json.Unmarshal(*v, &resourceAccess)
				if err != nil {
					return err
				}
				rra.ResourceAccess = &resourceAccess
			}
		case "resourceAppId":
			if v != nil {
				var resourceAppID string
				err = json.Unmarshal(*v, &resourceAppID)
				if err != nil {
					return err
				}
				rra.ResourceAppID = &resourceAppID
			}
		}
	}

	return nil
}

// ResourceAccess specifies an OAuth 2.0 permission scope or an app role that an application requires. The
// resourceAccess property of the RequiredResourceAccess type is a collection of ResourceAccess.
type ResourceAccess struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ID - The unique identifier for one of the OAuth2Permission or AppRole instances that the resource application exposes.
	ID *string `json:"id,omitempty"`
	// Type - Specifies whether the id property references an OAuth2Permission or an AppRole. Possible values are "scope" or "role".
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceAccess.
func (ra ResourceAccess) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ra.ID != nil {
		objectMap["id"] = ra.ID
	}
	if ra.Type != nil {
		objectMap["type"] = ra.Type
	}
	for k, v := range ra.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourceAccess struct.
func (ra *ResourceAccess) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ra.AdditionalProperties == nil {
					ra.AdditionalProperties = make(map[string]interface{})
				}
				ra.AdditionalProperties[k] = additionalProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ra.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ra.Type = &typeVar
			}
		}
	}

	return nil
}

// ServicePrincipal active Directory service principal information.
type ServicePrincipal struct {
	autorest.Response `json:"-"`
	// AccountEnabled - whether or not the service principal account is enabled
	AccountEnabled *bool `json:"accountEnabled,omitempty"`
	// AlternativeNames - alternative names
	AlternativeNames *[]string `json:"alternativeNames,omitempty"`
	// AppDisplayName - READ-ONLY; The display name exposed by the associated application.
	AppDisplayName *string `json:"appDisplayName,omitempty"`
	// AppID - The application ID.
	AppID *string `json:"appId,omitempty"`
	// AppOwnerTenantID - READ-ONLY
	AppOwnerTenantID *string `json:"appOwnerTenantId,omitempty"`
	// AppRoleAssignmentRequired - Specifies whether an AppRoleAssignment to a user or group is required before Azure AD will issue a user or access token to the application.
	AppRoleAssignmentRequired *bool `json:"appRoleAssignmentRequired,omitempty"`
	// AppRoles - The collection of application roles that an application may declare. These roles can be assigned to users, groups or service principals.
	AppRoles *[]AppRole `json:"appRoles,omitempty"`
	// DisplayName - The display name of the service principal.
	DisplayName *string `json:"displayName,omitempty"`
	// ErrorURL - A URL provided by the author of the associated application to report errors when using the application.
	ErrorURL *string `json:"errorUrl,omitempty"`
	// Homepage - The URL to the homepage of the associated application.
	Homepage *string `json:"homepage,omitempty"`
	// KeyCredentials - The collection of key credentials associated with the service principal.
	KeyCredentials *[]KeyCredential `json:"keyCredentials,omitempty"`
	// LogoutURL - A URL provided by the author of the associated application to logout
	LogoutURL *string `json:"logoutUrl,omitempty"`
	// Oauth2Permissions - READ-ONLY; The OAuth 2.0 permissions exposed by the associated application.
	Oauth2Permissions *[]OAuth2Permission `json:"oauth2Permissions,omitempty"`
	// PasswordCredentials - The collection of password credentials associated with the service principal.
	PasswordCredentials *[]PasswordCredential `json:"passwordCredentials,omitempty"`
	// PreferredTokenSigningKeyThumbprint - The thumbprint of preferred certificate to sign the token
	PreferredTokenSigningKeyThumbprint *string `json:"preferredTokenSigningKeyThumbprint,omitempty"`
	// PublisherName - The publisher's name of the associated application
	PublisherName *string `json:"publisherName,omitempty"`
	// ReplyUrls - The URLs that user tokens are sent to for sign in with the associated application.  The redirect URIs that the oAuth 2.0 authorization code and access tokens are sent to for the associated application.
	ReplyUrls *[]string `json:"replyUrls,omitempty"`
	// SamlMetadataURL - The URL to the SAML metadata of the associated application
	SamlMetadataURL *string `json:"samlMetadataUrl,omitempty"`
	// ServicePrincipalNames - A collection of service principal names.
	ServicePrincipalNames *[]string `json:"servicePrincipalNames,omitempty"`
	// ServicePrincipalType - the type of the service principal
	ServicePrincipalType *string `json:"servicePrincipalType,omitempty"`
	// Tags - Optional list of tags that you can apply to your service principals. Not nullable.
	Tags *[]string `json:"tags,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ObjectID - READ-ONLY; The object ID.
	ObjectID *string `json:"objectId,omitempty"`
	// DeletionTimestamp - READ-ONLY; The time at which the directory object was deleted.
	DeletionTimestamp *date.Time `json:"deletionTimestamp,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeDirectoryObject', 'ObjectTypeApplication', 'ObjectTypeGroup', 'ObjectTypeServicePrincipal', 'ObjectTypeUser'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for ServicePrincipal.
func (sp ServicePrincipal) MarshalJSON() ([]byte, error) {
	sp.ObjectType = ObjectTypeServicePrincipal
	objectMap := make(map[string]interface{})
	if sp.AccountEnabled != nil {
		objectMap["accountEnabled"] = sp.AccountEnabled
	}
	if sp.AlternativeNames != nil {
		objectMap["alternativeNames"] = sp.AlternativeNames
	}
	if sp.AppID != nil {
		objectMap["appId"] = sp.AppID
	}
	if sp.AppRoleAssignmentRequired != nil {
		objectMap["appRoleAssignmentRequired"] = sp.AppRoleAssignmentRequired
	}
	if sp.AppRoles != nil {
		objectMap["appRoles"] = sp.AppRoles
	}
	if sp.DisplayName != nil {
		objectMap["displayName"] = sp.DisplayName
	}
	if sp.ErrorURL != nil {
		objectMap["errorUrl"] = sp.ErrorURL
	}
	if sp.Homepage != nil {
		objectMap["homepage"] = sp.Homepage
	}
	if sp.KeyCredentials != nil {
		objectMap["keyCredentials"] = sp.KeyCredentials
	}
	if sp.LogoutURL != nil {
		objectMap["logoutUrl"] = sp.LogoutURL
	}
	if sp.PasswordCredentials != nil {
		objectMap["passwordCredentials"] = sp.PasswordCredentials
	}
	if sp.PreferredTokenSigningKeyThumbprint != nil {
		objectMap["preferredTokenSigningKeyThumbprint"] = sp.PreferredTokenSigningKeyThumbprint
	}
	if sp.PublisherName != nil {
		objectMap["publisherName"] = sp.PublisherName
	}
	if sp.ReplyUrls != nil {
		objectMap["replyUrls"] = sp.ReplyUrls
	}
	if sp.SamlMetadataURL != nil {
		objectMap["samlMetadataUrl"] = sp.SamlMetadataURL
	}
	if sp.ServicePrincipalNames != nil {
		objectMap["servicePrincipalNames"] = sp.ServicePrincipalNames
	}
	if sp.ServicePrincipalType != nil {
		objectMap["servicePrincipalType"] = sp.ServicePrincipalType
	}
	if sp.Tags != nil {
		objectMap["tags"] = sp.Tags
	}
	if sp.ObjectType != "" {
		objectMap["objectType"] = sp.ObjectType
	}
	for k, v := range sp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsApplication is the BasicDirectoryObject implementation for ServicePrincipal.
func (sp ServicePrincipal) AsApplication() (*Application, bool) {
	return nil, false
}

// AsADGroup is the BasicDirectoryObject implementation for ServicePrincipal.
func (sp ServicePrincipal) AsADGroup() (*ADGroup, bool) {
	return nil, false
}

// AsServicePrincipal is the BasicDirectoryObject implementation for ServicePrincipal.
func (sp ServicePrincipal) AsServicePrincipal() (*ServicePrincipal, bool) {
	return &sp, true
}

// AsUser is the BasicDirectoryObject implementation for ServicePrincipal.
func (sp ServicePrincipal) AsUser() (*User, bool) {
	return nil, false
}

// AsDirectoryObject is the BasicDirectoryObject implementation for ServicePrincipal.
func (sp ServicePrincipal) AsDirectoryObject() (*DirectoryObject, bool) {
	return nil, false
}

// AsBasicDirectoryObject is the BasicDirectoryObject implementation for ServicePrincipal.
func (sp ServicePrincipal) AsBasicDirectoryObject() (BasicDirectoryObject, bool) {
	return &sp, true
}

// UnmarshalJSON is the custom unmarshaler for ServicePrincipal struct.
func (sp *ServicePrincipal) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "accountEnabled":
			if v != nil {
				var accountEnabled bool
				err = json.Unmarshal(*v, &accountEnabled)
				if err != nil {
					return err
				}
				sp.AccountEnabled = &accountEnabled
			}
		case "alternativeNames":
			if v != nil {
				var alternativeNames []string
				err = json.Unmarshal(*v, &alternativeNames)
				if err != nil {
					return err
				}
				sp.AlternativeNames = &alternativeNames
			}
		case "appDisplayName":
			if v != nil {
				var appDisplayName string
				err = json.Unmarshal(*v, &appDisplayName)
				if err != nil {
					return err
				}
				sp.AppDisplayName = &appDisplayName
			}
		case "appId":
			if v != nil {
				var appID string
				err = json.Unmarshal(*v, &appID)
				if err != nil {
					return err
				}
				sp.AppID = &appID
			}
		case "appOwnerTenantId":
			if v != nil {
				var appOwnerTenantID string
				err = json.Unmarshal(*v, &appOwnerTenantID)
				if err != nil {
					return err
				}
				sp.AppOwnerTenantID = &appOwnerTenantID
			}
		case "appRoleAssignmentRequired":
			if v != nil {
				var appRoleAssignmentRequired bool
				err = json.Unmarshal(*v, &appRoleAssignmentRequired)
				if err != nil {
					return err
				}
				sp.AppRoleAssignmentRequired = &appRoleAssignmentRequired
			}
		case "appRoles":
			if v != nil {
				var appRoles []AppRole
				err = json.Unmarshal(*v, &appRoles)
				if err != nil {
					return err
				}
				sp.AppRoles = &appRoles
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				sp.DisplayName = &displayName
			}
		case "errorUrl":
			if v != nil {
				var errorURL string
				err = json.Unmarshal(*v, &errorURL)
				if err != nil {
					return err
				}
				sp.ErrorURL = &errorURL
			}
		case "homepage":
			if v != nil {
				var homepage string
				err = json.Unmarshal(*v, &homepage)
				if err != nil {
					return err
				}
				sp.Homepage = &homepage
			}
		case "keyCredentials":
			if v != nil {
				var keyCredentials []KeyCredential
				err = json.Unmarshal(*v, &keyCredentials)
				if err != nil {
					return err
				}
				sp.KeyCredentials = &keyCredentials
			}
		case "logoutUrl":
			if v != nil {
				var logoutURL string
				err = json.Unmarshal(*v, &logoutURL)
				if err != nil {
					return err
				}
				sp.LogoutURL = &logoutURL
			}
		case "oauth2Permissions":
			if v != nil {
				var oauth2Permissions []OAuth2Permission
				err = json.Unmarshal(*v, &oauth2Permissions)
				if err != nil {
					return err
				}
				sp.Oauth2Permissions = &oauth2Permissions
			}
		case "passwordCredentials":
			if v != nil {
				var passwordCredentials []PasswordCredential
				err = json.Unmarshal(*v, &passwordCredentials)
				if err != nil {
					return err
				}
				sp.PasswordCredentials = &passwordCredentials
			}
		case "preferredTokenSigningKeyThumbprint":
			if v != nil {
				var preferredTokenSigningKeyThumbprint string
				err = json.Unmarshal(*v, &preferredTokenSigningKeyThumbprint)
				if err != nil {
					return err
				}
				sp.PreferredTokenSigningKeyThumbprint = &preferredTokenSigningKeyThumbprint
			}
		case "publisherName":
			if v != nil {
				var publisherName string
				err = json.Unmarshal(*v, &publisherName)
				if err != nil {
					return err
				}
				sp.PublisherName = &publisherName
			}
		case "replyUrls":
			if v != nil {
				var replyUrls []string
				err = json.Unmarshal(*v, &replyUrls)
				if err != nil {
					return err
				}
				sp.ReplyUrls = &replyUrls
			}
		case "samlMetadataUrl":
			if v != nil {
				var samlMetadataURL string
				err = json.Unmarshal(*v, &samlMetadataURL)
				if err != nil {
					return err
				}
				sp.SamlMetadataURL = &samlMetadataURL
			}
		case "servicePrincipalNames":
			if v != nil {
				var servicePrincipalNames []string
				err = json.Unmarshal(*v, &servicePrincipalNames)
				if err != nil {
					return err
				}
				sp.ServicePrincipalNames = &servicePrincipalNames
			}
		case "servicePrincipalType":
			if v != nil {
				var servicePrincipalType string
				err = json.Unmarshal(*v, &servicePrincipalType)
				if err != nil {
					return err
				}
				sp.ServicePrincipalType = &servicePrincipalType
			}
		case "tags":
			if v != nil {
				var tags []string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sp.Tags = &tags
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if sp.AdditionalProperties == nil {
					sp.AdditionalProperties = make(map[string]interface{})
				}
				sp.AdditionalProperties[k] = additionalProperties
			}
		case "objectId":
			if v != nil {
				var objectID string
				err = json.Unmarshal(*v, &objectID)
				if err != nil {
					return err
				}
				sp.ObjectID = &objectID
			}
		case "deletionTimestamp":
			if v != nil {
				var deletionTimestamp date.Time
				err = json.Unmarshal(*v, &deletionTimestamp)
				if err != nil {
					return err
				}
				sp.DeletionTimestamp = &deletionTimestamp
			}
		case "objectType":
			if v != nil {
				var objectType ObjectType
				err = json.Unmarshal(*v, &objectType)
				if err != nil {
					return err
				}
				sp.ObjectType = objectType
			}
		}
	}

	return nil
}

// ServicePrincipalBase active Directory service principal common properties shared among GET, POST and
// PATCH
type ServicePrincipalBase struct {
	// AccountEnabled - whether or not the service principal account is enabled
	AccountEnabled *bool `json:"accountEnabled,omitempty"`
	// AppRoleAssignmentRequired - Specifies whether an AppRoleAssignment to a user or group is required before Azure AD will issue a user or access token to the application.
	AppRoleAssignmentRequired *bool `json:"appRoleAssignmentRequired,omitempty"`
	// KeyCredentials - The collection of key credentials associated with the service principal.
	KeyCredentials *[]KeyCredential `json:"keyCredentials,omitempty"`
	// PasswordCredentials - The collection of password credentials associated with the service principal.
	PasswordCredentials *[]PasswordCredential `json:"passwordCredentials,omitempty"`
	// ServicePrincipalType - the type of the service principal
	ServicePrincipalType *string `json:"servicePrincipalType,omitempty"`
	// Tags - Optional list of tags that you can apply to your service principals. Not nullable.
	Tags *[]string `json:"tags,omitempty"`
}

// ServicePrincipalCreateParameters request parameters for creating a new service principal.
type ServicePrincipalCreateParameters struct {
	// AppID - The application ID.
	AppID *string `json:"appId,omitempty"`
	// AccountEnabled - whether or not the service principal account is enabled
	AccountEnabled *bool `json:"accountEnabled,omitempty"`
	// AppRoleAssignmentRequired - Specifies whether an AppRoleAssignment to a user or group is required before Azure AD will issue a user or access token to the application.
	AppRoleAssignmentRequired *bool `json:"appRoleAssignmentRequired,omitempty"`
	// KeyCredentials - The collection of key credentials associated with the service principal.
	KeyCredentials *[]KeyCredential `json:"keyCredentials,omitempty"`
	// PasswordCredentials - The collection of password credentials associated with the service principal.
	PasswordCredentials *[]PasswordCredential `json:"passwordCredentials,omitempty"`
	// ServicePrincipalType - the type of the service principal
	ServicePrincipalType *string `json:"servicePrincipalType,omitempty"`
	// Tags - Optional list of tags that you can apply to your service principals. Not nullable.
	Tags *[]string `json:"tags,omitempty"`
}

// ServicePrincipalListResult server response for get tenant service principals API call.
type ServicePrincipalListResult struct {
	autorest.Response `json:"-"`
	// Value - the list of service principals.
	Value *[]ServicePrincipal `json:"value,omitempty"`
	// OdataNextLink - the URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// ServicePrincipalListResultIterator provides access to a complete listing of ServicePrincipal values.
type ServicePrincipalListResultIterator struct {
	i    int
	page ServicePrincipalListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServicePrincipalListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicePrincipalListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServicePrincipalListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServicePrincipalListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServicePrincipalListResultIterator) Response() ServicePrincipalListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServicePrincipalListResultIterator) Value() ServicePrincipal {
	if !iter.page.NotDone() {
		return ServicePrincipal{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServicePrincipalListResultIterator type.
func NewServicePrincipalListResultIterator(page ServicePrincipalListResultPage) ServicePrincipalListResultIterator {
	return ServicePrincipalListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (splr ServicePrincipalListResult) IsEmpty() bool {
	return splr.Value == nil || len(*splr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (splr ServicePrincipalListResult) hasNextLink() bool {
	return splr.OdataNextLink != nil && len(*splr.OdataNextLink) != 0
}

// ServicePrincipalListResultPage contains a page of ServicePrincipal values.
type ServicePrincipalListResultPage struct {
	fn   func(context.Context, ServicePrincipalListResult) (ServicePrincipalListResult, error)
	splr ServicePrincipalListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServicePrincipalListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicePrincipalListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.splr)
		if err != nil {
			return err
		}
		page.splr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServicePrincipalListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServicePrincipalListResultPage) NotDone() bool {
	return !page.splr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServicePrincipalListResultPage) Response() ServicePrincipalListResult {
	return page.splr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServicePrincipalListResultPage) Values() []ServicePrincipal {
	if page.splr.IsEmpty() {
		return nil
	}
	return *page.splr.Value
}

// Creates a new instance of the ServicePrincipalListResultPage type.
func NewServicePrincipalListResultPage(cur ServicePrincipalListResult, getNextPage func(context.Context, ServicePrincipalListResult) (ServicePrincipalListResult, error)) ServicePrincipalListResultPage {
	return ServicePrincipalListResultPage{
		fn:   getNextPage,
		splr: cur,
	}
}

// ServicePrincipalObjectResult service Principal Object Result.
type ServicePrincipalObjectResult struct {
	autorest.Response `json:"-"`
	// Value - The Object ID of the service principal with the specified application ID.
	Value *string `json:"value,omitempty"`
	// OdataMetadata - The URL representing edm equivalent.
	OdataMetadata *string `json:"odata.metadata,omitempty"`
}

// ServicePrincipalUpdateParameters request parameters for update an existing service principal.
type ServicePrincipalUpdateParameters struct {
	// AccountEnabled - whether or not the service principal account is enabled
	AccountEnabled *bool `json:"accountEnabled,omitempty"`
	// AppRoleAssignmentRequired - Specifies whether an AppRoleAssignment to a user or group is required before Azure AD will issue a user or access token to the application.
	AppRoleAssignmentRequired *bool `json:"appRoleAssignmentRequired,omitempty"`
	// KeyCredentials - The collection of key credentials associated with the service principal.
	KeyCredentials *[]KeyCredential `json:"keyCredentials,omitempty"`
	// PasswordCredentials - The collection of password credentials associated with the service principal.
	PasswordCredentials *[]PasswordCredential `json:"passwordCredentials,omitempty"`
	// ServicePrincipalType - the type of the service principal
	ServicePrincipalType *string `json:"servicePrincipalType,omitempty"`
	// Tags - Optional list of tags that you can apply to your service principals. Not nullable.
	Tags *[]string `json:"tags,omitempty"`
}

// SignInName contains information about a sign-in name of a local account user in an Azure Active
// Directory B2C tenant.
type SignInName struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Type - A string value that can be used to classify user sign-in types in your directory, such as 'emailAddress' or 'userName'.
	Type *string `json:"type,omitempty"`
	// Value - The sign-in used by the local account. Must be unique across the company/tenant. For example, 'johnc@example.com'.
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for SignInName.
func (sin SignInName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sin.Type != nil {
		objectMap["type"] = sin.Type
	}
	if sin.Value != nil {
		objectMap["value"] = sin.Value
	}
	for k, v := range sin.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SignInName struct.
func (sin *SignInName) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if sin.AdditionalProperties == nil {
					sin.AdditionalProperties = make(map[string]interface{})
				}
				sin.AdditionalProperties[k] = additionalProperties
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sin.Type = &typeVar
			}
		case "value":
			if v != nil {
				var value string
				err = json.Unmarshal(*v, &value)
				if err != nil {
					return err
				}
				sin.Value = &value
			}
		}
	}

	return nil
}

// User active Directory user information.
type User struct {
	autorest.Response `json:"-"`
	// ImmutableID - This must be specified if you are using a federated domain for the user's userPrincipalName (UPN) property when creating a new user account. It is used to associate an on-premises Active Directory user account with their Azure AD user object.
	ImmutableID *string `json:"immutableId,omitempty"`
	// UsageLocation - A two letter country code (ISO standard 3166). Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. Examples include: "US", "JP", and "GB".
	UsageLocation *string `json:"usageLocation,omitempty"`
	// GivenName - The given name for the user.
	GivenName *string `json:"givenName,omitempty"`
	// Surname - The user's surname (family name or last name).
	Surname *string `json:"surname,omitempty"`
	// UserType - A string value that can be used to classify user types in your directory, such as 'Member' and 'Guest'. Possible values include: 'Member', 'Guest'
	UserType UserType `json:"userType,omitempty"`
	// AccountEnabled - Whether the account is enabled.
	AccountEnabled *bool `json:"accountEnabled,omitempty"`
	// DisplayName - The display name of the user.
	DisplayName *string `json:"displayName,omitempty"`
	// UserPrincipalName - The principal name of the user.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// MailNickname - The mail alias for the user.
	MailNickname *string `json:"mailNickname,omitempty"`
	// Mail - The primary email address of the user.
	Mail *string `json:"mail,omitempty"`
	// SignInNames - The sign-in names of the user.
	SignInNames *[]SignInName `json:"signInNames,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ObjectID - READ-ONLY; The object ID.
	ObjectID *string `json:"objectId,omitempty"`
	// DeletionTimestamp - READ-ONLY; The time at which the directory object was deleted.
	DeletionTimestamp *date.Time `json:"deletionTimestamp,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeDirectoryObject', 'ObjectTypeApplication', 'ObjectTypeGroup', 'ObjectTypeServicePrincipal', 'ObjectTypeUser'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for User.
func (u User) MarshalJSON() ([]byte, error) {
	u.ObjectType = ObjectTypeUser
	objectMap := make(map[string]interface{})
	if u.ImmutableID != nil {
		objectMap["immutableId"] = u.ImmutableID
	}
	if u.UsageLocation != nil {
		objectMap["usageLocation"] = u.UsageLocation
	}
	if u.GivenName != nil {
		objectMap["givenName"] = u.GivenName
	}
	if u.Surname != nil {
		objectMap["surname"] = u.Surname
	}
	if u.UserType != "" {
		objectMap["userType"] = u.UserType
	}
	if u.AccountEnabled != nil {
		objectMap["accountEnabled"] = u.AccountEnabled
	}
	if u.DisplayName != nil {
		objectMap["displayName"] = u.DisplayName
	}
	if u.UserPrincipalName != nil {
		objectMap["userPrincipalName"] = u.UserPrincipalName
	}
	if u.MailNickname != nil {
		objectMap["mailNickname"] = u.MailNickname
	}
	if u.Mail != nil {
		objectMap["mail"] = u.Mail
	}
	if u.SignInNames != nil {
		objectMap["signInNames"] = u.SignInNames
	}
	if u.ObjectType != "" {
		objectMap["objectType"] = u.ObjectType
	}
	for k, v := range u.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsApplication is the BasicDirectoryObject implementation for User.
func (u User) AsApplication() (*Application, bool) {
	return nil, false
}

// AsADGroup is the BasicDirectoryObject implementation for User.
func (u User) AsADGroup() (*ADGroup, bool) {
	return nil, false
}

// AsServicePrincipal is the BasicDirectoryObject implementation for User.
func (u User) AsServicePrincipal() (*ServicePrincipal, bool) {
	return nil, false
}

// AsUser is the BasicDirectoryObject implementation for User.
func (u User) AsUser() (*User, bool) {
	return &u, true
}

// AsDirectoryObject is the BasicDirectoryObject implementation for User.
func (u User) AsDirectoryObject() (*DirectoryObject, bool) {
	return nil, false
}

// AsBasicDirectoryObject is the BasicDirectoryObject implementation for User.
func (u User) AsBasicDirectoryObject() (BasicDirectoryObject, bool) {
	return &u, true
}

// UnmarshalJSON is the custom unmarshaler for User struct.
func (u *User) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "immutableId":
			if v != nil {
				var immutableID string
				err = json.Unmarshal(*v, &immutableID)
				if err != nil {
					return err
				}
				u.ImmutableID = &immutableID
			}
		case "usageLocation":
			if v != nil {
				var usageLocation string
				err = json.Unmarshal(*v, &usageLocation)
				if err != nil {
					return err
				}
				u.UsageLocation = &usageLocation
			}
		case "givenName":
			if v != nil {
				var givenName string
				err = json.Unmarshal(*v, &givenName)
				if err != nil {
					return err
				}
				u.GivenName = &givenName
			}
		case "surname":
			if v != nil {
				var surname string
				err = json.Unmarshal(*v, &surname)
				if err != nil {
					return err
				}
				u.Surname = &surname
			}
		case "userType":
			if v != nil {
				var userType UserType
				err = json.Unmarshal(*v, &userType)
				if err != nil {
					return err
				}
				u.UserType = userType
			}
		case "accountEnabled":
			if v != nil {
				var accountEnabled bool
				err = json.Unmarshal(*v, &accountEnabled)
				if err != nil {
					return err
				}
				u.AccountEnabled = &accountEnabled
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				u.DisplayName = &displayName
			}
		case "userPrincipalName":
			if v != nil {
				var userPrincipalName string
				err = json.Unmarshal(*v, &userPrincipalName)
				if err != nil {
					return err
				}
				u.UserPrincipalName = &userPrincipalName
			}
		case "mailNickname":
			if v != nil {
				var mailNickname string
				err = json.Unmarshal(*v, &mailNickname)
				if err != nil {
					return err
				}
				u.MailNickname = &mailNickname
			}
		case "mail":
			if v != nil {
				var mailVar string
				err = json.Unmarshal(*v, &mailVar)
				if err != nil {
					return err
				}
				u.Mail = &mailVar
			}
		case "signInNames":
			if v != nil {
				var signInNames []SignInName
				err = json.Unmarshal(*v, &signInNames)
				if err != nil {
					return err
				}
				u.SignInNames = &signInNames
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if u.AdditionalProperties == nil {
					u.AdditionalProperties = make(map[string]interface{})
				}
				u.AdditionalProperties[k] = additionalProperties
			}
		case "objectId":
			if v != nil {
				var objectID string
				err = json.Unmarshal(*v, &objectID)
				if err != nil {
					return err
				}
				u.ObjectID = &objectID
			}
		case "deletionTimestamp":
			if v != nil {
				var deletionTimestamp date.Time
				err = json.Unmarshal(*v, &deletionTimestamp)
				if err != nil {
					return err
				}
				u.DeletionTimestamp = &deletionTimestamp
			}
		case "objectType":
			if v != nil {
				var objectType ObjectType
				err = json.Unmarshal(*v, &objectType)
				if err != nil {
					return err
				}
				u.ObjectType = objectType
			}
		}
	}

	return nil
}

// UserBase ...
type UserBase struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ImmutableID - This must be specified if you are using a federated domain for the user's userPrincipalName (UPN) property when creating a new user account. It is used to associate an on-premises Active Directory user account with their Azure AD user object.
	ImmutableID *string `json:"immutableId,omitempty"`
	// UsageLocation - A two letter country code (ISO standard 3166). Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. Examples include: "US", "JP", and "GB".
	UsageLocation *string `json:"usageLocation,omitempty"`
	// GivenName - The given name for the user.
	GivenName *string `json:"givenName,omitempty"`
	// Surname - The user's surname (family name or last name).
	Surname *string `json:"surname,omitempty"`
	// UserType - A string value that can be used to classify user types in your directory, such as 'Member' and 'Guest'. Possible values include: 'Member', 'Guest'
	UserType UserType `json:"userType,omitempty"`
}

// MarshalJSON is the custom marshaler for UserBase.
func (ub UserBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ub.ImmutableID != nil {
		objectMap["immutableId"] = ub.ImmutableID
	}
	if ub.UsageLocation != nil {
		objectMap["usageLocation"] = ub.UsageLocation
	}
	if ub.GivenName != nil {
		objectMap["givenName"] = ub.GivenName
	}
	if ub.Surname != nil {
		objectMap["surname"] = ub.Surname
	}
	if ub.UserType != "" {
		objectMap["userType"] = ub.UserType
	}
	for k, v := range ub.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UserBase struct.
func (ub *UserBase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ub.AdditionalProperties == nil {
					ub.AdditionalProperties = make(map[string]interface{})
				}
				ub.AdditionalProperties[k] = additionalProperties
			}
		case "immutableId":
			if v != nil {
				var immutableID string
				err = json.Unmarshal(*v, &immutableID)
				if err != nil {
					return err
				}
				ub.ImmutableID = &immutableID
			}
		case "usageLocation":
			if v != nil {
				var usageLocation string
				err = json.Unmarshal(*v, &usageLocation)
				if err != nil {
					return err
				}
				ub.UsageLocation = &usageLocation
			}
		case "givenName":
			if v != nil {
				var givenName string
				err = json.Unmarshal(*v, &givenName)
				if err != nil {
					return err
				}
				ub.GivenName = &givenName
			}
		case "surname":
			if v != nil {
				var surname string
				err = json.Unmarshal(*v, &surname)
				if err != nil {
					return err
				}
				ub.Surname = &surname
			}
		case "userType":
			if v != nil {
				var userType UserType
				err = json.Unmarshal(*v, &userType)
				if err != nil {
					return err
				}
				ub.UserType = userType
			}
		}
	}

	return nil
}

// UserCreateParameters request parameters for creating a new work or school account user.
type UserCreateParameters struct {
	// AccountEnabled - Whether the account is enabled.
	AccountEnabled *bool `json:"accountEnabled,omitempty"`
	// DisplayName - The display name of the user.
	DisplayName *string `json:"displayName,omitempty"`
	// PasswordProfile - Password Profile
	PasswordProfile *PasswordProfile `json:"passwordProfile,omitempty"`
	// UserPrincipalName - The user principal name (someuser@contoso.com). It must contain one of the verified domains for the tenant.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// MailNickname - The mail alias for the user.
	MailNickname *string `json:"mailNickname,omitempty"`
	// Mail - The primary email address of the user.
	Mail *string `json:"mail,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ImmutableID - This must be specified if you are using a federated domain for the user's userPrincipalName (UPN) property when creating a new user account. It is used to associate an on-premises Active Directory user account with their Azure AD user object.
	ImmutableID *string `json:"immutableId,omitempty"`
	// UsageLocation - A two letter country code (ISO standard 3166). Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. Examples include: "US", "JP", and "GB".
	UsageLocation *string `json:"usageLocation,omitempty"`
	// GivenName - The given name for the user.
	GivenName *string `json:"givenName,omitempty"`
	// Surname - The user's surname (family name or last name).
	Surname *string `json:"surname,omitempty"`
	// UserType - A string value that can be used to classify user types in your directory, such as 'Member' and 'Guest'. Possible values include: 'Member', 'Guest'
	UserType UserType `json:"userType,omitempty"`
}

// MarshalJSON is the custom marshaler for UserCreateParameters.
func (ucp UserCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ucp.AccountEnabled != nil {
		objectMap["accountEnabled"] = ucp.AccountEnabled
	}
	if ucp.DisplayName != nil {
		objectMap["displayName"] = ucp.DisplayName
	}
	if ucp.PasswordProfile != nil {
		objectMap["passwordProfile"] = ucp.PasswordProfile
	}
	if ucp.UserPrincipalName != nil {
		objectMap["userPrincipalName"] = ucp.UserPrincipalName
	}
	if ucp.MailNickname != nil {
		objectMap["mailNickname"] = ucp.MailNickname
	}
	if ucp.Mail != nil {
		objectMap["mail"] = ucp.Mail
	}
	if ucp.ImmutableID != nil {
		objectMap["immutableId"] = ucp.ImmutableID
	}
	if ucp.UsageLocation != nil {
		objectMap["usageLocation"] = ucp.UsageLocation
	}
	if ucp.GivenName != nil {
		objectMap["givenName"] = ucp.GivenName
	}
	if ucp.Surname != nil {
		objectMap["surname"] = ucp.Surname
	}
	if ucp.UserType != "" {
		objectMap["userType"] = ucp.UserType
	}
	for k, v := range ucp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UserCreateParameters struct.
func (ucp *UserCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "accountEnabled":
			if v != nil {
				var accountEnabled bool
				err = json.Unmarshal(*v, &accountEnabled)
				if err != nil {
					return err
				}
				ucp.AccountEnabled = &accountEnabled
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				ucp.DisplayName = &displayName
			}
		case "passwordProfile":
			if v != nil {
				var passwordProfile PasswordProfile
				err = json.Unmarshal(*v, &passwordProfile)
				if err != nil {
					return err
				}
				ucp.PasswordProfile = &passwordProfile
			}
		case "userPrincipalName":
			if v != nil {
				var userPrincipalName string
				err = json.Unmarshal(*v, &userPrincipalName)
				if err != nil {
					return err
				}
				ucp.UserPrincipalName = &userPrincipalName
			}
		case "mailNickname":
			if v != nil {
				var mailNickname string
				err = json.Unmarshal(*v, &mailNickname)
				if err != nil {
					return err
				}
				ucp.MailNickname = &mailNickname
			}
		case "mail":
			if v != nil {
				var mailVar string
				err = json.Unmarshal(*v, &mailVar)
				if err != nil {
					return err
				}
				ucp.Mail = &mailVar
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ucp.AdditionalProperties == nil {
					ucp.AdditionalProperties = make(map[string]interface{})
				}
				ucp.AdditionalProperties[k] = additionalProperties
			}
		case "immutableId":
			if v != nil {
				var immutableID string
				err = json.Unmarshal(*v, &immutableID)
				if err != nil {
					return err
				}
				ucp.ImmutableID = &immutableID
			}
		case "usageLocation":
			if v != nil {
				var usageLocation string
				err = json.Unmarshal(*v, &usageLocation)
				if err != nil {
					return err
				}
				ucp.UsageLocation = &usageLocation
			}
		case "givenName":
			if v != nil {
				var givenName string
				err = json.Unmarshal(*v, &givenName)
				if err != nil {
					return err
				}
				ucp.GivenName = &givenName
			}
		case "surname":
			if v != nil {
				var surname string
				err = json.Unmarshal(*v, &surname)
				if err != nil {
					return err
				}
				ucp.Surname = &surname
			}
		case "userType":
			if v != nil {
				var userType UserType
				err = json.Unmarshal(*v, &userType)
				if err != nil {
					return err
				}
				ucp.UserType = userType
			}
		}
	}

	return nil
}

// UserGetMemberGroupsParameters request parameters for GetMemberGroups API call.
type UserGetMemberGroupsParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SecurityEnabledOnly - If true, only membership in security-enabled groups should be checked. Otherwise, membership in all groups should be checked.
	SecurityEnabledOnly *bool `json:"securityEnabledOnly,omitempty"`
}

// MarshalJSON is the custom marshaler for UserGetMemberGroupsParameters.
func (ugmgp UserGetMemberGroupsParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ugmgp.SecurityEnabledOnly != nil {
		objectMap["securityEnabledOnly"] = ugmgp.SecurityEnabledOnly
	}
	for k, v := range ugmgp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UserGetMemberGroupsParameters struct.
func (ugmgp *UserGetMemberGroupsParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ugmgp.AdditionalProperties == nil {
					ugmgp.AdditionalProperties = make(map[string]interface{})
				}
				ugmgp.AdditionalProperties[k] = additionalProperties
			}
		case "securityEnabledOnly":
			if v != nil {
				var securityEnabledOnly bool
				err = json.Unmarshal(*v, &securityEnabledOnly)
				if err != nil {
					return err
				}
				ugmgp.SecurityEnabledOnly = &securityEnabledOnly
			}
		}
	}

	return nil
}

// UserGetMemberGroupsResult server response for GetMemberGroups API call.
type UserGetMemberGroupsResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of group IDs of which the user is a member.
	Value *[]string `json:"value,omitempty"`
}

// UserListResult server response for Get tenant users API call.
type UserListResult struct {
	autorest.Response `json:"-"`
	// Value - the list of users.
	Value *[]User `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// UserListResultIterator provides access to a complete listing of User values.
type UserListResultIterator struct {
	i    int
	page UserListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UserListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UserListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UserListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UserListResultIterator) Response() UserListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UserListResultIterator) Value() User {
	if !iter.page.NotDone() {
		return User{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UserListResultIterator type.
func NewUserListResultIterator(page UserListResultPage) UserListResultIterator {
	return UserListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ulr UserListResult) IsEmpty() bool {
	return ulr.Value == nil || len(*ulr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ulr UserListResult) hasNextLink() bool {
	return ulr.OdataNextLink != nil && len(*ulr.OdataNextLink) != 0
}

// UserListResultPage contains a page of User values.
type UserListResultPage struct {
	fn  func(context.Context, UserListResult) (UserListResult, error)
	ulr UserListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UserListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ulr)
		if err != nil {
			return err
		}
		page.ulr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UserListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UserListResultPage) NotDone() bool {
	return !page.ulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UserListResultPage) Response() UserListResult {
	return page.ulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UserListResultPage) Values() []User {
	if page.ulr.IsEmpty() {
		return nil
	}
	return *page.ulr.Value
}

// Creates a new instance of the UserListResultPage type.
func NewUserListResultPage(cur UserListResult, getNextPage func(context.Context, UserListResult) (UserListResult, error)) UserListResultPage {
	return UserListResultPage{
		fn:  getNextPage,
		ulr: cur,
	}
}

// UserUpdateParameters request parameters for updating an existing work or school account user.
type UserUpdateParameters struct {
	// AccountEnabled - Whether the account is enabled.
	AccountEnabled *bool `json:"accountEnabled,omitempty"`
	// DisplayName - The display name of the user.
	DisplayName *string `json:"displayName,omitempty"`
	// PasswordProfile - The password profile of the user.
	PasswordProfile *PasswordProfile `json:"passwordProfile,omitempty"`
	// UserPrincipalName - The user principal name (someuser@contoso.com). It must contain one of the verified domains for the tenant.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// MailNickname - The mail alias for the user.
	MailNickname *string `json:"mailNickname,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ImmutableID - This must be specified if you are using a federated domain for the user's userPrincipalName (UPN) property when creating a new user account. It is used to associate an on-premises Active Directory user account with their Azure AD user object.
	ImmutableID *string `json:"immutableId,omitempty"`
	// UsageLocation - A two letter country code (ISO standard 3166). Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. Examples include: "US", "JP", and "GB".
	UsageLocation *string `json:"usageLocation,omitempty"`
	// GivenName - The given name for the user.
	GivenName *string `json:"givenName,omitempty"`
	// Surname - The user's surname (family name or last name).
	Surname *string `json:"surname,omitempty"`
	// UserType - A string value that can be used to classify user types in your directory, such as 'Member' and 'Guest'. Possible values include: 'Member', 'Guest'
	UserType UserType `json:"userType,omitempty"`
}

// MarshalJSON is the custom marshaler for UserUpdateParameters.
func (uup UserUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uup.AccountEnabled != nil {
		objectMap["accountEnabled"] = uup.AccountEnabled
	}
	if uup.DisplayName != nil {
		objectMap["displayName"] = uup.DisplayName
	}
	if uup.PasswordProfile != nil {
		objectMap["passwordProfile"] = uup.PasswordProfile
	}
	if uup.UserPrincipalName != nil {
		objectMap["userPrincipalName"] = uup.UserPrincipalName
	}
	if uup.MailNickname != nil {
		objectMap["mailNickname"] = uup.MailNickname
	}
	if uup.ImmutableID != nil {
		objectMap["immutableId"] = uup.ImmutableID
	}
	if uup.UsageLocation != nil {
		objectMap["usageLocation"] = uup.UsageLocation
	}
	if uup.GivenName != nil {
		objectMap["givenName"] = uup.GivenName
	}
	if uup.Surname != nil {
		objectMap["surname"] = uup.Surname
	}
	if uup.UserType != "" {
		objectMap["userType"] = uup.UserType
	}
	for k, v := range uup.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UserUpdateParameters struct.
func (uup *UserUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "accountEnabled":
			if v != nil {
				var accountEnabled bool
				err = json.Unmarshal(*v, &accountEnabled)
				if err != nil {
					return err
				}
				uup.AccountEnabled = &accountEnabled
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				uup.DisplayName = &displayName
			}
		case "passwordProfile":
			if v != nil {
				var passwordProfile PasswordProfile
				err = json.Unmarshal(*v, &passwordProfile)
				if err != nil {
					return err
				}
				uup.PasswordProfile = &passwordProfile
			}
		case "userPrincipalName":
			if v != nil {
				var userPrincipalName string
				err = json.Unmarshal(*v, &userPrincipalName)
				if err != nil {
					return err
				}
				uup.UserPrincipalName = &userPrincipalName
			}
		case "mailNickname":
			if v != nil {
				var mailNickname string
				err = json.Unmarshal(*v, &mailNickname)
				if err != nil {
					return err
				}
				uup.MailNickname = &mailNickname
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if uup.AdditionalProperties == nil {
					uup.AdditionalProperties = make(map[string]interface{})
				}
				uup.AdditionalProperties[k] = additionalProperties
			}
		case "immutableId":
			if v != nil {
				var immutableID string
				err = json.Unmarshal(*v, &immutableID)
				if err != nil {
					return err
				}
				uup.ImmutableID = &immutableID
			}
		case "usageLocation":
			if v != nil {
				var usageLocation string
				err = json.Unmarshal(*v, &usageLocation)
				if err != nil {
					return err
				}
				uup.UsageLocation = &usageLocation
			}
		case "givenName":
			if v != nil {
				var givenName string
				err = json.Unmarshal(*v, &givenName)
				if err != nil {
					return err
				}
				uup.GivenName = &givenName
			}
		case "surname":
			if v != nil {
				var surname string
				err = json.Unmarshal(*v, &surname)
				if err != nil {
					return err
				}
				uup.Surname = &surname
			}
		case "userType":
			if v != nil {
				var userType UserType
				err = json.Unmarshal(*v, &userType)
				if err != nil {
					return err
				}
				uup.UserType = userType
			}
		}
	}

	return nil
}
