package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetInstancesProtection invokes the ess.SetInstancesProtection API synchronously
// api document: https://help.aliyun.com/api/ess/setinstancesprotection.html
func (client *Client) SetInstancesProtection(request *SetInstancesProtectionRequest) (response *SetInstancesProtectionResponse, err error) {
	response = CreateSetInstancesProtectionResponse()
	err = client.DoAction(request, response)
	return
}

// SetInstancesProtectionWithChan invokes the ess.SetInstancesProtection API asynchronously
// api document: https://help.aliyun.com/api/ess/setinstancesprotection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetInstancesProtectionWithChan(request *SetInstancesProtectionRequest) (<-chan *SetInstancesProtectionResponse, <-chan error) {
	responseChan := make(chan *SetInstancesProtectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetInstancesProtection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetInstancesProtectionWithCallback invokes the ess.SetInstancesProtection API asynchronously
// api document: https://help.aliyun.com/api/ess/setinstancesprotection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetInstancesProtectionWithCallback(request *SetInstancesProtectionRequest, callback func(response *SetInstancesProtectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetInstancesProtectionResponse
		var err error
		defer close(result)
		response, err = client.SetInstancesProtection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetInstancesProtectionRequest is the request struct for api SetInstancesProtection
type SetInstancesProtectionRequest struct {
	*requests.RpcRequest
	ScalingGroupId       string           `position:"Query" name:"ScalingGroupId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           *[]string        `position:"Query" name:"InstanceId"  type:"Repeated"`
	ProtectedFromScaleIn requests.Boolean `position:"Query" name:"ProtectedFromScaleIn"`
}

// SetInstancesProtectionResponse is the response struct for api SetInstancesProtection
type SetInstancesProtectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetInstancesProtectionRequest creates a request to invoke SetInstancesProtection API
func CreateSetInstancesProtectionRequest() (request *SetInstancesProtectionRequest) {
	request = &SetInstancesProtectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "SetInstancesProtection", "ess", "openAPI")
	return
}

// CreateSetInstancesProtectionResponse creates a response to parse from SetInstancesProtection response
func CreateSetInstancesProtectionResponse() (response *SetInstancesProtectionResponse) {
	response = &SetInstancesProtectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
