package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AbortCampaign invokes the ccc.AbortCampaign API synchronously
func (client *Client) AbortCampaign(request *AbortCampaignRequest) (response *AbortCampaignResponse, err error) {
	response = CreateAbortCampaignResponse()
	err = client.DoAction(request, response)
	return
}

// AbortCampaignWithChan invokes the ccc.AbortCampaign API asynchronously
func (client *Client) AbortCampaignWithChan(request *AbortCampaignRequest) (<-chan *AbortCampaignResponse, <-chan error) {
	responseChan := make(chan *AbortCampaignResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AbortCampaign(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AbortCampaignWithCallback invokes the ccc.AbortCampaign API asynchronously
func (client *Client) AbortCampaignWithCallback(request *AbortCampaignRequest, callback func(response *AbortCampaignResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AbortCampaignResponse
		var err error
		defer close(result)
		response, err = client.AbortCampaign(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AbortCampaignRequest is the request struct for api AbortCampaign
type AbortCampaignRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	CampaignId string `position:"Query" name:"CampaignId"`
}

// AbortCampaignResponse is the response struct for api AbortCampaign
type AbortCampaignResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode string `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateAbortCampaignRequest creates a request to invoke AbortCampaign API
func CreateAbortCampaignRequest() (request *AbortCampaignRequest) {
	request = &AbortCampaignRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "AbortCampaign", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAbortCampaignResponse creates a response to parse from AbortCampaign response
func CreateAbortCampaignResponse() (response *AbortCampaignResponse) {
	response = &AbortCampaignResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
