package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSdkUrl invokes the cloudauth.DescribeSdkUrl API synchronously
func (client *Client) DescribeSdkUrl(request *DescribeSdkUrlRequest) (response *DescribeSdkUrlResponse, err error) {
	response = CreateDescribeSdkUrlResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSdkUrlWithChan invokes the cloudauth.DescribeSdkUrl API asynchronously
func (client *Client) DescribeSdkUrlWithChan(request *DescribeSdkUrlRequest) (<-chan *DescribeSdkUrlResponse, <-chan error) {
	responseChan := make(chan *DescribeSdkUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSdkUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSdkUrlWithCallback invokes the cloudauth.DescribeSdkUrl API asynchronously
func (client *Client) DescribeSdkUrlWithCallback(request *DescribeSdkUrlRequest, callback func(response *DescribeSdkUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSdkUrlResponse
		var err error
		defer close(result)
		response, err = client.DescribeSdkUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSdkUrlRequest is the request struct for api DescribeSdkUrl
type DescribeSdkUrlRequest struct {
	*requests.RpcRequest
	Debug    requests.Boolean `position:"Query" name:"Debug"`
	SourceIp string           `position:"Query" name:"SourceIp"`
	Id       requests.Integer `position:"Query" name:"Id"`
}

// DescribeSdkUrlResponse is the response struct for api DescribeSdkUrl
type DescribeSdkUrlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	SdkUrl    string `json:"SdkUrl" xml:"SdkUrl"`
}

// CreateDescribeSdkUrlRequest creates a request to invoke DescribeSdkUrl API
func CreateDescribeSdkUrlRequest() (request *DescribeSdkUrlRequest) {
	request = &DescribeSdkUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "DescribeSdkUrl", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSdkUrlResponse creates a response to parse from DescribeSdkUrl response
func CreateDescribeSdkUrlResponse() (response *DescribeSdkUrlResponse) {
	response = &DescribeSdkUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
