package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyBankElement invokes the cloudauth.VerifyBankElement API synchronously
func (client *Client) VerifyBankElement(request *VerifyBankElementRequest) (response *VerifyBankElementResponse, err error) {
	response = CreateVerifyBankElementResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyBankElementWithChan invokes the cloudauth.VerifyBankElement API asynchronously
func (client *Client) VerifyBankElementWithChan(request *VerifyBankElementRequest) (<-chan *VerifyBankElementResponse, <-chan error) {
	responseChan := make(chan *VerifyBankElementResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyBankElement(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyBankElementWithCallback invokes the cloudauth.VerifyBankElement API asynchronously
func (client *Client) VerifyBankElementWithCallback(request *VerifyBankElementRequest, callback func(response *VerifyBankElementResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyBankElementResponse
		var err error
		defer close(result)
		response, err = client.VerifyBankElement(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyBankElementRequest is the request struct for api VerifyBankElement
type VerifyBankElementRequest struct {
	*requests.RpcRequest
	IdName       string           `position:"Body" name:"IdName"`
	Mobile       string           `position:"Body" name:"Mobile"`
	BankCardUrl  string           `position:"Body" name:"BankCardUrl"`
	IdNo         string           `position:"Body" name:"IdNo"`
	BankCardNo   string           `position:"Body" name:"BankCardNo"`
	Mode         string           `position:"Body" name:"Mode"`
	OuterOrderNo string           `position:"Body" name:"OuterOrderNo"`
	BankCardFile string           `position:"Body" name:"BankCardFile"`
	SceneId      requests.Integer `position:"Body" name:"SceneId"`
}

// VerifyBankElementResponse is the response struct for api VerifyBankElement
type VerifyBankElementResponse struct {
	*responses.BaseResponse
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateVerifyBankElementRequest creates a request to invoke VerifyBankElement API
func CreateVerifyBankElementRequest() (request *VerifyBankElementRequest) {
	request = &VerifyBankElementRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2020-06-18", "VerifyBankElement", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateVerifyBankElementResponse creates a response to parse from VerifyBankElement response
func CreateVerifyBankElementResponse() (response *VerifyBankElementResponse) {
	response = &VerifyBankElementResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
