package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryVnConversations invokes the cloudcallcenter.QueryVnConversations API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/queryvnconversations.html
func (client *Client) QueryVnConversations(request *QueryVnConversationsRequest) (response *QueryVnConversationsResponse, err error) {
	response = CreateQueryVnConversationsResponse()
	err = client.DoAction(request, response)
	return
}

// QueryVnConversationsWithChan invokes the cloudcallcenter.QueryVnConversations API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/queryvnconversations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryVnConversationsWithChan(request *QueryVnConversationsRequest) (<-chan *QueryVnConversationsResponse, <-chan error) {
	responseChan := make(chan *QueryVnConversationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryVnConversations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryVnConversationsWithCallback invokes the cloudcallcenter.QueryVnConversations API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/queryvnconversations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryVnConversationsWithCallback(request *QueryVnConversationsRequest, callback func(response *QueryVnConversationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryVnConversationsResponse
		var err error
		defer close(result)
		response, err = client.QueryVnConversations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryVnConversationsRequest is the request struct for api QueryVnConversations
type QueryVnConversationsRequest struct {
	*requests.RpcRequest
	BeginTimeLeftRange  requests.Integer `position:"Query" name:"BeginTimeLeftRange"`
	PageNumber          requests.Integer `position:"Query" name:"PageNumber"`
	CallingNumber       string           `position:"Query" name:"CallingNumber"`
	InstanceId          string           `position:"Query" name:"InstanceId"`
	BeginTimeRightRange requests.Integer `position:"Query" name:"BeginTimeRightRange"`
	PageSize            requests.Integer `position:"Query" name:"PageSize"`
}

// QueryVnConversationsResponse is the response struct for api QueryVnConversations
type QueryVnConversationsResponse struct {
	*responses.BaseResponse
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	TotalCount    int64          `json:"TotalCount" xml:"TotalCount"`
	PageNumber    int            `json:"PageNumber" xml:"PageNumber"`
	PageSize      int            `json:"PageSize" xml:"PageSize"`
	Conversations []Conversation `json:"Conversations" xml:"Conversations"`
}

// CreateQueryVnConversationsRequest creates a request to invoke QueryVnConversations API
func CreateQueryVnConversationsRequest() (request *QueryVnConversationsRequest) {
	request = &QueryVnConversationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "QueryVnConversations", "", "")
	request.Method = requests.GET
	return
}

// CreateQueryVnConversationsResponse creates a response to parse from QueryVnConversations response
func CreateQueryVnConversationsResponse() (response *QueryVnConversationsResponse) {
	response = &QueryVnConversationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
