package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMergeRequestDetail invokes the codeup.GetMergeRequestDetail API synchronously
func (client *Client) GetMergeRequestDetail(request *GetMergeRequestDetailRequest) (response *GetMergeRequestDetailResponse, err error) {
	response = CreateGetMergeRequestDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetMergeRequestDetailWithChan invokes the codeup.GetMergeRequestDetail API asynchronously
func (client *Client) GetMergeRequestDetailWithChan(request *GetMergeRequestDetailRequest) (<-chan *GetMergeRequestDetailResponse, <-chan error) {
	responseChan := make(chan *GetMergeRequestDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMergeRequestDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMergeRequestDetailWithCallback invokes the codeup.GetMergeRequestDetail API asynchronously
func (client *Client) GetMergeRequestDetailWithCallback(request *GetMergeRequestDetailRequest, callback func(response *GetMergeRequestDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMergeRequestDetailResponse
		var err error
		defer close(result)
		response, err = client.GetMergeRequestDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMergeRequestDetailRequest is the request struct for api GetMergeRequestDetail
type GetMergeRequestDetailRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	MergeRequestId requests.Integer `position:"Path" name:"MergeRequestId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// GetMergeRequestDetailResponse is the response struct for api GetMergeRequestDetail
type GetMergeRequestDetailResponse struct {
	*responses.BaseResponse
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateGetMergeRequestDetailRequest creates a request to invoke GetMergeRequestDetail API
func CreateGetMergeRequestDetailRequest() (request *GetMergeRequestDetailRequest) {
	request = &GetMergeRequestDetailRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "GetMergeRequestDetail", "/api/v4/projects/[ProjectId]/merge_request/[MergeRequestId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetMergeRequestDetailResponse creates a response to parse from GetMergeRequestDetail response
func CreateGetMergeRequestDetailResponse() (response *GetMergeRequestDetailResponse) {
	response = &GetMergeRequestDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
