package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AcceptPartnerNotification invokes the companyreg.AcceptPartnerNotification API synchronously
func (client *Client) AcceptPartnerNotification(request *AcceptPartnerNotificationRequest) (response *AcceptPartnerNotificationResponse, err error) {
	response = CreateAcceptPartnerNotificationResponse()
	err = client.DoAction(request, response)
	return
}

// AcceptPartnerNotificationWithChan invokes the companyreg.AcceptPartnerNotification API asynchronously
func (client *Client) AcceptPartnerNotificationWithChan(request *AcceptPartnerNotificationRequest) (<-chan *AcceptPartnerNotificationResponse, <-chan error) {
	responseChan := make(chan *AcceptPartnerNotificationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AcceptPartnerNotification(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AcceptPartnerNotificationWithCallback invokes the companyreg.AcceptPartnerNotification API asynchronously
func (client *Client) AcceptPartnerNotificationWithCallback(request *AcceptPartnerNotificationRequest, callback func(response *AcceptPartnerNotificationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AcceptPartnerNotificationResponse
		var err error
		defer close(result)
		response, err = client.AcceptPartnerNotification(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AcceptPartnerNotificationRequest is the request struct for api AcceptPartnerNotification
type AcceptPartnerNotificationRequest struct {
	*requests.RpcRequest
	CertificateEndTime   string           `position:"Query" name:"CertificateEndTime"`
	ApplicationStatus    requests.Integer `position:"Query" name:"ApplicationStatus"`
	CertificateNumber    string           `position:"Query" name:"CertificateNumber"`
	OfficialFileURL      string           `position:"Query" name:"OfficialFileURL"`
	CertificateStartTime string           `position:"Query" name:"CertificateStartTime"`
	BizId                string           `position:"Query" name:"BizId"`
}

// AcceptPartnerNotificationResponse is the response struct for api AcceptPartnerNotification
type AcceptPartnerNotificationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateAcceptPartnerNotificationRequest creates a request to invoke AcceptPartnerNotification API
func CreateAcceptPartnerNotificationRequest() (request *AcceptPartnerNotificationRequest) {
	request = &AcceptPartnerNotificationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "AcceptPartnerNotification", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAcceptPartnerNotificationResponse creates a response to parse from AcceptPartnerNotification response
func CreateAcceptPartnerNotificationResponse() (response *AcceptPartnerNotificationResponse) {
	response = &AcceptPartnerNotificationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
