package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiscoveredResource invokes the config.DescribeDiscoveredResource API synchronously
func (client *Client) DescribeDiscoveredResource(request *DescribeDiscoveredResourceRequest) (response *DescribeDiscoveredResourceResponse, err error) {
	response = CreateDescribeDiscoveredResourceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiscoveredResourceWithChan invokes the config.DescribeDiscoveredResource API asynchronously
func (client *Client) DescribeDiscoveredResourceWithChan(request *DescribeDiscoveredResourceRequest) (<-chan *DescribeDiscoveredResourceResponse, <-chan error) {
	responseChan := make(chan *DescribeDiscoveredResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiscoveredResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiscoveredResourceWithCallback invokes the config.DescribeDiscoveredResource API asynchronously
func (client *Client) DescribeDiscoveredResourceWithCallback(request *DescribeDiscoveredResourceRequest, callback func(response *DescribeDiscoveredResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiscoveredResourceResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiscoveredResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiscoveredResourceRequest is the request struct for api DescribeDiscoveredResource
type DescribeDiscoveredResourceRequest struct {
	*requests.RpcRequest
	ResourceId   string           `position:"Query" name:"ResourceId"`
	MultiAccount requests.Boolean `position:"Query" name:"MultiAccount"`
	ResourceType string           `position:"Query" name:"ResourceType"`
	Region       string           `position:"Query" name:"Region"`
	MemberId     requests.Integer `position:"Query" name:"MemberId"`
}

// DescribeDiscoveredResourceResponse is the response struct for api DescribeDiscoveredResource
type DescribeDiscoveredResourceResponse struct {
	*responses.BaseResponse
	RequestId                string                   `json:"RequestId" xml:"RequestId"`
	DiscoveredResourceDetail DiscoveredResourceDetail `json:"DiscoveredResourceDetail" xml:"DiscoveredResourceDetail"`
}

// CreateDescribeDiscoveredResourceRequest creates a request to invoke DescribeDiscoveredResource API
func CreateDescribeDiscoveredResourceRequest() (request *DescribeDiscoveredResourceRequest) {
	request = &DescribeDiscoveredResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2019-01-08", "DescribeDiscoveredResource", "Config", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeDiscoveredResourceResponse creates a response to parse from DescribeDiscoveredResource response
func CreateDescribeDiscoveredResourceResponse() (response *DescribeDiscoveredResourceResponse) {
	response = &DescribeDiscoveredResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
