package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateApm invokes the elasticsearch.UpdateApm API synchronously
func (client *Client) UpdateApm(request *UpdateApmRequest) (response *UpdateApmResponse, err error) {
	response = CreateUpdateApmResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateApmWithChan invokes the elasticsearch.UpdateApm API asynchronously
func (client *Client) UpdateApmWithChan(request *UpdateApmRequest) (<-chan *UpdateApmResponse, <-chan error) {
	responseChan := make(chan *UpdateApmResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateApm(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateApmWithCallback invokes the elasticsearch.UpdateApm API asynchronously
func (client *Client) UpdateApmWithCallback(request *UpdateApmRequest, callback func(response *UpdateApmResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateApmResponse
		var err error
		defer close(result)
		response, err = client.UpdateApm(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateApmRequest is the request struct for api UpdateApm
type UpdateApmRequest struct {
	*requests.RoaRequest
	OutputES         string `position:"Query" name:"outputES"`
	OutputESPassword string `position:"Query" name:"outputESPassword"`
	InstanceId       string `position:"Path" name:"instanceId"`
	Yml              string `position:"Query" name:"yml"`
	OutputESUserName string `position:"Query" name:"outputESUserName"`
	Token            string `position:"Query" name:"token"`
}

// UpdateApmResponse is the response struct for api UpdateApm
type UpdateApmResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateUpdateApmRequest creates a request to invoke UpdateApm API
func CreateUpdateApmRequest() (request *UpdateApmRequest) {
	request = &UpdateApmRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdateApm", "/openapi/apm/[instanceId]", "elasticsearch", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateApmResponse creates a response to parse from UpdateApm response
func CreateUpdateApmResponse() (response *UpdateApmResponse) {
	response = &UpdateApmResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
