package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFaceEntity invokes the facebody.DeleteFaceEntity API synchronously
func (client *Client) DeleteFaceEntity(request *DeleteFaceEntityRequest) (response *DeleteFaceEntityResponse, err error) {
	response = CreateDeleteFaceEntityResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFaceEntityWithChan invokes the facebody.DeleteFaceEntity API asynchronously
func (client *Client) DeleteFaceEntityWithChan(request *DeleteFaceEntityRequest) (<-chan *DeleteFaceEntityResponse, <-chan error) {
	responseChan := make(chan *DeleteFaceEntityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFaceEntity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFaceEntityWithCallback invokes the facebody.DeleteFaceEntity API asynchronously
func (client *Client) DeleteFaceEntityWithCallback(request *DeleteFaceEntityRequest, callback func(response *DeleteFaceEntityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFaceEntityResponse
		var err error
		defer close(result)
		response, err = client.DeleteFaceEntity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFaceEntityRequest is the request struct for api DeleteFaceEntity
type DeleteFaceEntityRequest struct {
	*requests.RpcRequest
	EntityId string `position:"Body" name:"EntityId"`
	DbName   string `position:"Body" name:"DbName"`
}

// DeleteFaceEntityResponse is the response struct for api DeleteFaceEntity
type DeleteFaceEntityResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteFaceEntityRequest creates a request to invoke DeleteFaceEntity API
func CreateDeleteFaceEntityRequest() (request *DeleteFaceEntityRequest) {
	request = &DeleteFaceEntityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "DeleteFaceEntity", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteFaceEntityResponse creates a response to parse from DeleteFaceEntity response
func CreateDeleteFaceEntityResponse() (response *DeleteFaceEntityResponse) {
	response = &DeleteFaceEntityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
