package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyFaceMask invokes the facebody.VerifyFaceMask API synchronously
func (client *Client) VerifyFaceMask(request *VerifyFaceMaskRequest) (response *VerifyFaceMaskResponse, err error) {
	response = CreateVerifyFaceMaskResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyFaceMaskWithChan invokes the facebody.VerifyFaceMask API asynchronously
func (client *Client) VerifyFaceMaskWithChan(request *VerifyFaceMaskRequest) (<-chan *VerifyFaceMaskResponse, <-chan error) {
	responseChan := make(chan *VerifyFaceMaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyFaceMask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyFaceMaskWithCallback invokes the facebody.VerifyFaceMask API asynchronously
func (client *Client) VerifyFaceMaskWithCallback(request *VerifyFaceMaskRequest, callback func(response *VerifyFaceMaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyFaceMaskResponse
		var err error
		defer close(result)
		response, err = client.VerifyFaceMask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyFaceMaskRequest is the request struct for api VerifyFaceMask
type VerifyFaceMaskRequest struct {
	*requests.RpcRequest
	RefData   string `position:"Body" name:"RefData"`
	ImageData string `position:"Body" name:"ImageData"`
	ImageURL  string `position:"Body" name:"ImageURL"`
	RefUrl    string `position:"Body" name:"RefUrl"`
}

// VerifyFaceMaskResponse is the response struct for api VerifyFaceMask
type VerifyFaceMaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateVerifyFaceMaskRequest creates a request to invoke VerifyFaceMask API
func CreateVerifyFaceMaskRequest() (request *VerifyFaceMaskRequest) {
	request = &VerifyFaceMaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "VerifyFaceMask", "", "")
	request.Method = requests.POST
	return
}

// CreateVerifyFaceMaskResponse creates a response to parse from VerifyFaceMask response
func CreateVerifyFaceMaskResponse() (response *VerifyFaceMaskResponse) {
	response = &VerifyFaceMaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
