package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BandwidthPackageRemoveAccelerator invokes the ga.BandwidthPackageRemoveAccelerator API synchronously
func (client *Client) BandwidthPackageRemoveAccelerator(request *BandwidthPackageRemoveAcceleratorRequest) (response *BandwidthPackageRemoveAcceleratorResponse, err error) {
	response = CreateBandwidthPackageRemoveAcceleratorResponse()
	err = client.DoAction(request, response)
	return
}

// BandwidthPackageRemoveAcceleratorWithChan invokes the ga.BandwidthPackageRemoveAccelerator API asynchronously
func (client *Client) BandwidthPackageRemoveAcceleratorWithChan(request *BandwidthPackageRemoveAcceleratorRequest) (<-chan *BandwidthPackageRemoveAcceleratorResponse, <-chan error) {
	responseChan := make(chan *BandwidthPackageRemoveAcceleratorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BandwidthPackageRemoveAccelerator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BandwidthPackageRemoveAcceleratorWithCallback invokes the ga.BandwidthPackageRemoveAccelerator API asynchronously
func (client *Client) BandwidthPackageRemoveAcceleratorWithCallback(request *BandwidthPackageRemoveAcceleratorRequest, callback func(response *BandwidthPackageRemoveAcceleratorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BandwidthPackageRemoveAcceleratorResponse
		var err error
		defer close(result)
		response, err = client.BandwidthPackageRemoveAccelerator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BandwidthPackageRemoveAcceleratorRequest is the request struct for api BandwidthPackageRemoveAccelerator
type BandwidthPackageRemoveAcceleratorRequest struct {
	*requests.RpcRequest
	BandwidthPackageId string `position:"Query" name:"BandwidthPackageId"`
	AcceleratorId      string `position:"Query" name:"AcceleratorId"`
}

// BandwidthPackageRemoveAcceleratorResponse is the response struct for api BandwidthPackageRemoveAccelerator
type BandwidthPackageRemoveAcceleratorResponse struct {
	*responses.BaseResponse
	RequestId          string   `json:"RequestId" xml:"RequestId"`
	BandwidthPackageId string   `json:"BandwidthPackageId" xml:"BandwidthPackageId"`
	Accelerators       []string `json:"Accelerators" xml:"Accelerators"`
}

// CreateBandwidthPackageRemoveAcceleratorRequest creates a request to invoke BandwidthPackageRemoveAccelerator API
func CreateBandwidthPackageRemoveAcceleratorRequest() (request *BandwidthPackageRemoveAcceleratorRequest) {
	request = &BandwidthPackageRemoveAcceleratorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "BandwidthPackageRemoveAccelerator", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBandwidthPackageRemoveAcceleratorResponse creates a response to parse from BandwidthPackageRemoveAccelerator response
func CreateBandwidthPackageRemoveAcceleratorResponse() (response *BandwidthPackageRemoveAcceleratorResponse) {
	response = &BandwidthPackageRemoveAcceleratorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
