package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefreshWebofficeToken invokes the imm.RefreshWebofficeToken API synchronously
func (client *Client) RefreshWebofficeToken(request *RefreshWebofficeTokenRequest) (response *RefreshWebofficeTokenResponse, err error) {
	response = CreateRefreshWebofficeTokenResponse()
	err = client.DoAction(request, response)
	return
}

// RefreshWebofficeTokenWithChan invokes the imm.RefreshWebofficeToken API asynchronously
func (client *Client) RefreshWebofficeTokenWithChan(request *RefreshWebofficeTokenRequest) (<-chan *RefreshWebofficeTokenResponse, <-chan error) {
	responseChan := make(chan *RefreshWebofficeTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefreshWebofficeToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefreshWebofficeTokenWithCallback invokes the imm.RefreshWebofficeToken API asynchronously
func (client *Client) RefreshWebofficeTokenWithCallback(request *RefreshWebofficeTokenRequest, callback func(response *RefreshWebofficeTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefreshWebofficeTokenResponse
		var err error
		defer close(result)
		response, err = client.RefreshWebofficeToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefreshWebofficeTokenRequest is the request struct for api RefreshWebofficeToken
type RefreshWebofficeTokenRequest struct {
	*requests.RpcRequest
	Project      string `position:"Query" name:"Project"`
	AccessToken  string `position:"Query" name:"AccessToken"`
	RefreshToken string `position:"Query" name:"RefreshToken"`
}

// RefreshWebofficeTokenResponse is the response struct for api RefreshWebofficeToken
type RefreshWebofficeTokenResponse struct {
	*responses.BaseResponse
	RefreshToken            string `json:"RefreshToken" xml:"RefreshToken"`
	RequestId               string `json:"RequestId" xml:"RequestId"`
	AccessToken             string `json:"AccessToken" xml:"AccessToken"`
	RefreshTokenExpiredTime string `json:"RefreshTokenExpiredTime" xml:"RefreshTokenExpiredTime"`
	AccessTokenExpiredTime  string `json:"AccessTokenExpiredTime" xml:"AccessTokenExpiredTime"`
}

// CreateRefreshWebofficeTokenRequest creates a request to invoke RefreshWebofficeToken API
func CreateRefreshWebofficeTokenRequest() (request *RefreshWebofficeTokenRequest) {
	request = &RefreshWebofficeTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "RefreshWebofficeToken", "imm", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRefreshWebofficeTokenResponse creates a response to parse from RefreshWebofficeToken response
func CreateRefreshWebofficeTokenResponse() (response *RefreshWebofficeTokenResponse) {
	response = &RefreshWebofficeTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
