package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSourceReplica invokes the iot.ListSourceReplica API synchronously
func (client *Client) ListSourceReplica(request *ListSourceReplicaRequest) (response *ListSourceReplicaResponse, err error) {
	response = CreateListSourceReplicaResponse()
	err = client.DoAction(request, response)
	return
}

// ListSourceReplicaWithChan invokes the iot.ListSourceReplica API asynchronously
func (client *Client) ListSourceReplicaWithChan(request *ListSourceReplicaRequest) (<-chan *ListSourceReplicaResponse, <-chan error) {
	responseChan := make(chan *ListSourceReplicaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSourceReplica(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSourceReplicaWithCallback invokes the iot.ListSourceReplica API asynchronously
func (client *Client) ListSourceReplicaWithCallback(request *ListSourceReplicaRequest, callback func(response *ListSourceReplicaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSourceReplicaResponse
		var err error
		defer close(result)
		response, err = client.ListSourceReplica(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSourceReplicaRequest is the request struct for api ListSourceReplica
type ListSourceReplicaRequest struct {
	*requests.RpcRequest
	IotInstanceId string           `position:"Body" name:"IotInstanceId"`
	Context       string           `position:"Body" name:"Context"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	SourceType    string           `position:"Query" name:"SourceType"`
	PageNo        requests.Integer `position:"Query" name:"PageNo"`
	LpInstanceId  string           `position:"Query" name:"LpInstanceId"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// ListSourceReplicaResponse is the response struct for api ListSourceReplica
type ListSourceReplicaResponse struct {
	*responses.BaseResponse
	RequestId    string                  `json:"RequestId" xml:"RequestId"`
	Success      bool                    `json:"Success" xml:"Success"`
	Code         string                  `json:"Code" xml:"Code"`
	ErrorMessage string                  `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInListSourceReplica `json:"Data" xml:"Data"`
}

// CreateListSourceReplicaRequest creates a request to invoke ListSourceReplica API
func CreateListSourceReplicaRequest() (request *ListSourceReplicaRequest) {
	request = &ListSourceReplicaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ListSourceReplica", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSourceReplicaResponse creates a response to parse from ListSourceReplica response
func CreateListSourceReplicaResponse() (response *ListSourceReplicaResponse) {
	response = &ListSourceReplicaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
