package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNodeGroupTransferPacketsDownloadUrl invokes the linkwan.GetNodeGroupTransferPacketsDownloadUrl API synchronously
func (client *Client) GetNodeGroupTransferPacketsDownloadUrl(request *GetNodeGroupTransferPacketsDownloadUrlRequest) (response *GetNodeGroupTransferPacketsDownloadUrlResponse, err error) {
	response = CreateGetNodeGroupTransferPacketsDownloadUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetNodeGroupTransferPacketsDownloadUrlWithChan invokes the linkwan.GetNodeGroupTransferPacketsDownloadUrl API asynchronously
func (client *Client) GetNodeGroupTransferPacketsDownloadUrlWithChan(request *GetNodeGroupTransferPacketsDownloadUrlRequest) (<-chan *GetNodeGroupTransferPacketsDownloadUrlResponse, <-chan error) {
	responseChan := make(chan *GetNodeGroupTransferPacketsDownloadUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNodeGroupTransferPacketsDownloadUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNodeGroupTransferPacketsDownloadUrlWithCallback invokes the linkwan.GetNodeGroupTransferPacketsDownloadUrl API asynchronously
func (client *Client) GetNodeGroupTransferPacketsDownloadUrlWithCallback(request *GetNodeGroupTransferPacketsDownloadUrlRequest, callback func(response *GetNodeGroupTransferPacketsDownloadUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNodeGroupTransferPacketsDownloadUrlResponse
		var err error
		defer close(result)
		response, err = client.GetNodeGroupTransferPacketsDownloadUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNodeGroupTransferPacketsDownloadUrlRequest is the request struct for api GetNodeGroupTransferPacketsDownloadUrl
type GetNodeGroupTransferPacketsDownloadUrlRequest struct {
	*requests.RpcRequest
	EndMillis     requests.Integer `position:"Query" name:"EndMillis"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	Ascending     requests.Boolean `position:"Query" name:"Ascending"`
	DevEui        string           `position:"Query" name:"DevEui"`
	NodeGroupId   string           `position:"Query" name:"NodeGroupId"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	Category      string           `position:"Query" name:"Category"`
	BeginMillis   requests.Integer `position:"Query" name:"BeginMillis"`
	SortingField  string           `position:"Query" name:"SortingField"`
}

// GetNodeGroupTransferPacketsDownloadUrlResponse is the response struct for api GetNodeGroupTransferPacketsDownloadUrl
type GetNodeGroupTransferPacketsDownloadUrlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetNodeGroupTransferPacketsDownloadUrlRequest creates a request to invoke GetNodeGroupTransferPacketsDownloadUrl API
func CreateGetNodeGroupTransferPacketsDownloadUrlRequest() (request *GetNodeGroupTransferPacketsDownloadUrlRequest) {
	request = &GetNodeGroupTransferPacketsDownloadUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "GetNodeGroupTransferPacketsDownloadUrl", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetNodeGroupTransferPacketsDownloadUrlResponse creates a response to parse from GetNodeGroupTransferPacketsDownloadUrl response
func CreateGetNodeGroupTransferPacketsDownloadUrlResponse() (response *GetNodeGroupTransferPacketsDownloadUrlResponse) {
	response = &GetNodeGroupTransferPacketsDownloadUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
