package onsmqtt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyToken invokes the onsmqtt.ApplyToken API synchronously
func (client *Client) ApplyToken(request *ApplyTokenRequest) (response *ApplyTokenResponse, err error) {
	response = CreateApplyTokenResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyTokenWithChan invokes the onsmqtt.ApplyToken API asynchronously
func (client *Client) ApplyTokenWithChan(request *ApplyTokenRequest) (<-chan *ApplyTokenResponse, <-chan error) {
	responseChan := make(chan *ApplyTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyTokenWithCallback invokes the onsmqtt.ApplyToken API asynchronously
func (client *Client) ApplyTokenWithCallback(request *ApplyTokenRequest, callback func(response *ApplyTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyTokenResponse
		var err error
		defer close(result)
		response, err = client.ApplyToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyTokenRequest is the request struct for api ApplyToken
type ApplyTokenRequest struct {
	*requests.RpcRequest
	ExpireTime requests.Integer `position:"Query" name:"ExpireTime"`
	Resources  string           `position:"Query" name:"Resources"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	Actions    string           `position:"Query" name:"Actions"`
}

// ApplyTokenResponse is the response struct for api ApplyToken
type ApplyTokenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Token     string `json:"Token" xml:"Token"`
}

// CreateApplyTokenRequest creates a request to invoke ApplyToken API
func CreateApplyTokenRequest() (request *ApplyTokenRequest) {
	request = &ApplyTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OnsMqtt", "2020-04-20", "ApplyToken", "onsmqtt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateApplyTokenResponse creates a response to parse from ApplyToken response
func CreateApplyTokenResponse() (response *ApplyTokenResponse) {
	response = &ApplyTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
