package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableMPURule invokes the rtc.DisableMPURule API synchronously
func (client *Client) DisableMPURule(request *DisableMPURuleRequest) (response *DisableMPURuleResponse, err error) {
	response = CreateDisableMPURuleResponse()
	err = client.DoAction(request, response)
	return
}

// DisableMPURuleWithChan invokes the rtc.DisableMPURule API asynchronously
func (client *Client) DisableMPURuleWithChan(request *DisableMPURuleRequest) (<-chan *DisableMPURuleResponse, <-chan error) {
	responseChan := make(chan *DisableMPURuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableMPURule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableMPURuleWithCallback invokes the rtc.DisableMPURule API asynchronously
func (client *Client) DisableMPURuleWithCallback(request *DisableMPURuleRequest, callback func(response *DisableMPURuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableMPURuleResponse
		var err error
		defer close(result)
		response, err = client.DisableMPURule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableMPURuleRequest is the request struct for api DisableMPURule
type DisableMPURuleRequest struct {
	*requests.RpcRequest
	ShowLog string           `position:"Query" name:"ShowLog"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	AppId   string           `position:"Query" name:"AppId"`
	RuleId  requests.Integer `position:"Query" name:"RuleId"`
}

// DisableMPURuleResponse is the response struct for api DisableMPURule
type DisableMPURuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableMPURuleRequest creates a request to invoke DisableMPURule API
func CreateDisableMPURuleRequest() (request *DisableMPURuleRequest) {
	request = &DisableMPURuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DisableMPURule", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableMPURuleResponse creates a response to parse from DisableMPURule response
func CreateDisableMPURuleResponse() (response *DisableMPURuleResponse) {
	response = &DisableMPURuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
