package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVodRealtimeLogDelivery invokes the vod.DeleteVodRealtimeLogDelivery API synchronously
func (client *Client) DeleteVodRealtimeLogDelivery(request *DeleteVodRealtimeLogDeliveryRequest) (response *DeleteVodRealtimeLogDeliveryResponse, err error) {
	response = CreateDeleteVodRealtimeLogDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVodRealtimeLogDeliveryWithChan invokes the vod.DeleteVodRealtimeLogDelivery API asynchronously
func (client *Client) DeleteVodRealtimeLogDeliveryWithChan(request *DeleteVodRealtimeLogDeliveryRequest) (<-chan *DeleteVodRealtimeLogDeliveryResponse, <-chan error) {
	responseChan := make(chan *DeleteVodRealtimeLogDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVodRealtimeLogDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVodRealtimeLogDeliveryWithCallback invokes the vod.DeleteVodRealtimeLogDelivery API asynchronously
func (client *Client) DeleteVodRealtimeLogDeliveryWithCallback(request *DeleteVodRealtimeLogDeliveryRequest, callback func(response *DeleteVodRealtimeLogDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVodRealtimeLogDeliveryResponse
		var err error
		defer close(result)
		response, err = client.DeleteVodRealtimeLogDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVodRealtimeLogDeliveryRequest is the request struct for api DeleteVodRealtimeLogDelivery
type DeleteVodRealtimeLogDeliveryRequest struct {
	*requests.RpcRequest
	Project    string           `position:"Query" name:"Project"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Region     string           `position:"Query" name:"Region"`
	Logstore   string           `position:"Query" name:"Logstore"`
}

// DeleteVodRealtimeLogDeliveryResponse is the response struct for api DeleteVodRealtimeLogDelivery
type DeleteVodRealtimeLogDeliveryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteVodRealtimeLogDeliveryRequest creates a request to invoke DeleteVodRealtimeLogDelivery API
func CreateDeleteVodRealtimeLogDeliveryRequest() (request *DeleteVodRealtimeLogDeliveryRequest) {
	request = &DeleteVodRealtimeLogDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DeleteVodRealtimeLogDelivery", "", "")
	request.Method = requests.GET
	return
}

// CreateDeleteVodRealtimeLogDeliveryResponse creates a response to parse from DeleteVodRealtimeLogDelivery response
func CreateDeleteVodRealtimeLogDeliveryResponse() (response *DeleteVodRealtimeLogDeliveryResponse) {
	response = &DeleteVodRealtimeLogDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
