package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDetectionTemplate invokes the vod.UpdateDetectionTemplate API synchronously
func (client *Client) UpdateDetectionTemplate(request *UpdateDetectionTemplateRequest) (response *UpdateDetectionTemplateResponse, err error) {
	response = CreateUpdateDetectionTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDetectionTemplateWithChan invokes the vod.UpdateDetectionTemplate API asynchronously
func (client *Client) UpdateDetectionTemplateWithChan(request *UpdateDetectionTemplateRequest) (<-chan *UpdateDetectionTemplateResponse, <-chan error) {
	responseChan := make(chan *UpdateDetectionTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDetectionTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDetectionTemplateWithCallback invokes the vod.UpdateDetectionTemplate API asynchronously
func (client *Client) UpdateDetectionTemplateWithCallback(request *UpdateDetectionTemplateRequest, callback func(response *UpdateDetectionTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDetectionTemplateResponse
		var err error
		defer close(result)
		response, err = client.UpdateDetectionTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDetectionTemplateRequest is the request struct for api UpdateDetectionTemplate
type UpdateDetectionTemplateRequest struct {
	*requests.RpcRequest
	LetterSendTime      string           `position:"Query" name:"LetterSendTime"`
	AutoLetterSuspect   requests.Boolean `position:"Query" name:"AutoLetterSuspect"`
	Platform            string           `position:"Query" name:"Platform"`
	AutoLetter          requests.Boolean `position:"Query" name:"AutoLetter"`
	TemplateName        string           `position:"Query" name:"TemplateName"`
	AutoEvidence        requests.Boolean `position:"Query" name:"AutoEvidence"`
	LetterTemplateId    string           `position:"Query" name:"LetterTemplateId"`
	Period              string           `position:"Query" name:"Period"`
	AutoEvidenceSuspect requests.Boolean `position:"Query" name:"AutoEvidenceSuspect"`
	TemplateId          string           `position:"Query" name:"TemplateId"`
}

// UpdateDetectionTemplateResponse is the response struct for api UpdateDetectionTemplate
type UpdateDetectionTemplateResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	DetectionTemplate DetectionTemplate `json:"DetectionTemplate" xml:"DetectionTemplate"`
}

// CreateUpdateDetectionTemplateRequest creates a request to invoke UpdateDetectionTemplate API
func CreateUpdateDetectionTemplateRequest() (request *UpdateDetectionTemplateRequest) {
	request = &UpdateDetectionTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "UpdateDetectionTemplate", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateDetectionTemplateResponse creates a response to parse from UpdateDetectionTemplate response
func CreateUpdateDetectionTemplateResponse() (response *UpdateDetectionTemplateResponse) {
	response = &UpdateDetectionTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
