package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDomainConfig invokes the waf_openapi.ModifyDomainConfig API synchronously
func (client *Client) ModifyDomainConfig(request *ModifyDomainConfigRequest) (response *ModifyDomainConfigResponse, err error) {
	response = CreateModifyDomainConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDomainConfigWithChan invokes the waf_openapi.ModifyDomainConfig API asynchronously
func (client *Client) ModifyDomainConfigWithChan(request *ModifyDomainConfigRequest) (<-chan *ModifyDomainConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyDomainConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDomainConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDomainConfigWithCallback invokes the waf_openapi.ModifyDomainConfig API asynchronously
func (client *Client) ModifyDomainConfigWithCallback(request *ModifyDomainConfigRequest, callback func(response *ModifyDomainConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDomainConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyDomainConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDomainConfigRequest is the request struct for api ModifyDomainConfig
type ModifyDomainConfigRequest struct {
	*requests.RpcRequest
	SourceIp        string           `position:"Query" name:"SourceIp"`
	HttpPort        string           `position:"Query" name:"HttpPort"`
	Lang            string           `position:"Query" name:"Lang"`
	Protocols       string           `position:"Query" name:"Protocols"`
	HttpsRedirect   requests.Integer `position:"Query" name:"HttpsRedirect"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	SourceIps       string           `position:"Query" name:"SourceIps"`
	Domain          string           `position:"Query" name:"Domain"`
	IsAccessProduct requests.Integer `position:"Query" name:"IsAccessProduct"`
	HttpsPort       string           `position:"Query" name:"HttpsPort"`
	Region          string           `position:"Query" name:"Region"`
	LoadBalancing   requests.Integer `position:"Query" name:"LoadBalancing"`
	HttpToUserIp    requests.Integer `position:"Query" name:"HttpToUserIp"`
}

// ModifyDomainConfigResponse is the response struct for api ModifyDomainConfig
type ModifyDomainConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateModifyDomainConfigRequest creates a request to invoke ModifyDomainConfig API
func CreateModifyDomainConfigRequest() (request *ModifyDomainConfigRequest) {
	request = &ModifyDomainConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2018-01-17", "ModifyDomainConfig", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDomainConfigResponse creates a response to parse from ModifyDomainConfig response
func CreateModifyDomainConfigResponse() (response *ModifyDomainConfigResponse) {
	response = &ModifyDomainConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
